package org.kaoriha.marimite.testbench;

import java.util.Random;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

import org.kaoriha.marimite.LocalStopwatch;
import org.kaoriha.marimite.MarimiteConfig;
import org.kaoriha.marimite.Stopwatch;

public class TestBenchServlet extends HttpServlet {
	private Thread thread = null;
	private volatile boolean isStop = false;
	private static volatile boolean IS_INITIALIZED = false;

	@Override
	public void init() throws ServletException {
		super.init();

		System.out.println("ThreadServlet#init called");
		synchronized (TestBenchServlet.class) {
			if (IS_INITIALIZED) {
				return;
			}

			MarimiteConfig.start();
			MarimiteConfig.exportPlatformMBeanServer();

			isStop = false;
			Runnable r = new Runnable() {
				private Random rnd = new Random();

				public void run() {
					Stopwatch.start("start");
					LocalStopwatch lsw = new LocalStopwatch("local start");
					while (true) {
						if (rnd.nextBoolean()) {
							wait1();
						}
						if (rnd.nextBoolean()) {
							wait2();
						}
						if (isStop) {
							System.out.println("ThreadServlet thread exit");
							return;
						}
						lsw.lap("local 1");
					}
				}

				private void wait1() {
					wait(0, 40);
					Stopwatch.lap("wait1 exit");
				}

				private void wait2() {
					wait(20, 80);
					Stopwatch.lap("wait2 exit");
				}

				private void wait(int lower, int upper) {
					int w = lower + rnd.nextInt(upper - lower);
					try {
						Thread.sleep(w);
					} catch (InterruptedException e) {
						throw new RuntimeException(e);
					}
				}
			};
			thread = new Thread(r);
			thread.start();
			IS_INITIALIZED = true;
		}
	}

	@Override
	public void destroy() {
		System.out.println("ThreadServlet#destroy called");
		synchronized (TestBenchServlet.class) {
			if (IS_INITIALIZED) {
				isStop = true;
				thread = null;
				MarimiteConfig.stop();
				IS_INITIALIZED = false;
			}
		}
		super.destroy();
	}
}
