/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite.viewer.pref;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import org.kaoriha.marimite.viewer.pref.ClientPreference;

class JnlpImpl
extends ClientPreference {
    private static final long ALLOC_UNIT = 4096L;
    private static final PersistenceService PS;
    private static final String CODEBASE;
    private final String storeBase;

    JnlpImpl(String path) {
        String sb = CODEBASE;
        if (!sb.endsWith("/")) {
            sb = sb + "/";
        }
        this.storeBase = sb = sb + path + "_";
    }

    private URL getUrl(String key) throws MalformedURLException {
        return new URL(this.storeBase + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(String key, Serializable obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        long size = ((long)baos.size() / 4096L + 1L) * 4096L;
        boolean isFcOk = false;
        FileContents fc = null;
        URL url = this.getUrl(key);
        JnlpImpl jnlpImpl = this;
        synchronized (jnlpImpl) {
            try {
                fc = PS.get(url);
                if (fc.getMaxLength() >= size) {
                    isFcOk = true;
                } else {
                    PS.delete(url);
                }
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            if (!isFcOk) {
                long allocated = PS.create(url, size);
                if (allocated < size) {
                    throw new IOException("cannot allocate persistence size:" + size);
                }
                fc = PS.get(url);
            }
            OutputStream os = fc.getOutputStream(true);
            os.write(baos.toByteArray());
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object deserialize(String key) {
        FileContents fc = null;
        try {
            URL url = this.getUrl(key);
            JnlpImpl jnlpImpl = this;
            synchronized (jnlpImpl) {
                fc = PS.get(url);
                ObjectInputStream ois = new ObjectInputStream(fc.getInputStream());
                Object o = ois.readObject();
                ois.close();
                return o;
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            try {
                this.removeAll();
                return null;
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    @Override
    public Object deserialize(String key, Object alt) {
        Object o = this.deserialize(key);
        if (o == null) {
            return alt;
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() throws IOException {
        JnlpImpl jnlpImpl = this;
        synchronized (jnlpImpl) {
            try {
                for (String n : PS.getNames(new URL(CODEBASE))) {
                    PS.delete(new URL(n));
                }
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(JnlpImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    static {
        BasicService bs;
        try {
            PS = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
        }
        catch (UnavailableServiceException e) {
            throw new RuntimeException(e);
        }
        CODEBASE = bs.getCodeBase().toString();
    }
}

