#include "mnDef.h"
#include "mnModel.h"
#include <wx/dir.h>
#include <wx/regex.h>
#include <iconv.h>

static void   toLower(char* string);
static char*  decode(const char* string);
static char*  encode(const char* string);
static int    compWikiData(const void* wiki1, const void* wiki2);


/******* WikiList ************************/
#include <wx/listimpl.cpp>
WX_DEFINE_LIST(WikiList);


/******* mnModel ************************/

mnModel::mnModel(const char* dataDir)
{
	wxCSConv conv(wxT(CODE_SET_SYSTEM));

    wikiDataDir = new wxString(dataDir, conv);
	searchStrList = new wxArrayString();
}

mnModel::~mnModel()
{
	delete wikiDataDir;
}

/* 
 * iconv encode and create token list, 
 * so you must free tokenLis after you used 
 *
 * if failed to make token list, return FALSE.
 */
bool mnModel::makeSearchToken(const char* searchStr, char* tokenList[])
{
	iconv_t     codeSet;
	char        outbuf[MAX_BUF_SIZE];
	const char* inbufPtr   = searchStr;
	char*       outbufPtr  = outbuf;
	int         inbufSize  = strlen(searchStr);
	int         outbufSize = sizeof(outbuf);
	char*       token;
	int         i;

	memset(outbuf, 0, outbufSize);
	codeSet = iconv_open(CODE_SET_EUC_JP, CODE_SET_SYSTEM);
	if(codeSet == (iconv_t)-1) {
		MN_FATAL_ERROR(wxT("failed iconv_open"));
	}
	iconv(codeSet, (ICONV_CONST char**)&inbufPtr, (size_t*)&inbufSize, &outbufPtr, (size_t*)&outbufSize);
	iconv_close(codeSet);

	/* searchStr to Tokens */
	token = strtok(outbuf, " ");
	if(token == NULL) return false;
	tokenList[0] = (char*)malloc(strlen(token)+1);
	snprintf(tokenList[0], strlen(token)+1, "%s", token);
	i = 1;
	while((token = strtok(NULL, " ")) != NULL) {
		tokenList[i] = (char*)malloc(strlen(token)+1);
		snprintf(tokenList[i], strlen(token)+1, "%s", token);
		i++;
		if(i >= MAX_TOKEN) break;
	}
	return true;
}

bool mnModel::matchWithToken(wxString* fileName, char* tokenList[])
{
	const char* decodeFileName;
	char decodeFileNameBuf[MAX_BUF_SIZE];
    wxString    fullPathName;
 	FILE*       fp;
	bool        ans = false;
	bool        found;

    fullPathName = *wikiDataDir + wxT("/") + *fileName;
	fp = fopen((const char*)fullPathName.mb_str(), "r");
	if(fp == NULL) {
		return false;  /* because of removed */
	}

	/* TYPE search */
	if(strstr(tokenList[0], TYPESEARCH_TAG) == tokenList[0])
	{
		found = typeSearch(tokenList[0], fp);
		if(found){
			ans = true;
		}
	}
	/* Normal search */
	else{
		decodeFileName = decode(fileName->mb_str());
		snprintf(decodeFileNameBuf, MAX_BUF_SIZE, "%s", decodeFileName);
		toLower(decodeFileNameBuf);
		found = normalSearch(tokenList, fp, decodeFileNameBuf);
		if(found){
			ans = true;
		}
	}
	fclose(fp);

	return ans;
}

WikiList* mnModel::search(const char* searchStr)
{
	int         i;
	wxDir*      dir;
	WikiData*   wikiData;
    WikiList*   list = new WikiList();
    wxString*   fileName = new wxString();
	char*       tokenList[MAX_TOKEN];

	memset(tokenList, 0, sizeof(char*)*MAX_TOKEN);
	if( makeSearchToken(searchStr, tokenList) == false) return list;

	dir = new wxDir(*wikiDataDir);
    if ( !dir->IsOpened() )
    {
		MN_FATAL_ERROR(wxT("wxDir has faild\n"));
        return NULL;
    }

    bool cont = dir->GetFirst(fileName, wxT("*.txt"), wxDIR_FILES);
	while(cont){

		if( matchWithToken(fileName, tokenList) ) { /* match with token list */
			wikiData = new WikiData(wikiDataDir, fileName);
			list->Append(wikiData);
		}

        cont = dir->GetNext(fileName);
	}

	delete dir;
	delete fileName;
	for(i = 0; tokenList[i] != NULL; i++) free(tokenList[i]);

	list->Sort(compWikiData);
	return list;
}

/*
 *  add malon-type:xxx to search list
 */
void mnModel::group()
{
	wxCSConv    conv(wxT(CODE_SET_SYSTEM));
    char        buf[MAX_BUF_SIZE];
	wxDir*      dir;
 	FILE*       fp;
    wxString*   fileName = new wxString();
    wxString    fullPathName;
	int         typeTagLen = strlen(TYPE_TAG);
	char*       token;
	char*      	inbufPtr;
	int         inbufSize;
	char        outbuf[MAX_BUF_SIZE];
	char*       outbufPtr = outbuf;
	int         outbufSize;
	wxString*   typeToken;
	char*       ptr;
	int         i;

	iconv_t codeSet = iconv_open(CODE_SET_SYSTEM, CODE_SET_EUC_JP);
	if(codeSet == (iconv_t)-1) {
		MN_FATAL_ERROR(wxT("failed iconv_open"));
	}

	dir = new wxDir(*wikiDataDir);
    if ( !dir->IsOpened() )
    {
		MN_FATAL_ERROR(wxT("wxDir has faild\n"));
        return ;
    }
    bool cont = dir->GetFirst(fileName, wxT("*.txt"), wxDIR_FILES);
	while(cont){
        fullPathName = *wikiDataDir + wxT("/") + *fileName;
		fp = fopen((const char*)fullPathName.mb_str(), "r");
		if(fp == NULL) {
			MN_FATAL_ERROR(wxT("fopen faild"));
		}
		while(1) {
			memset(buf, 0, MAX_BUF_SIZE);
			fgets(buf, MAX_BUF_SIZE, fp);
			if(buf[0] == 0) break;
			if(strstr(buf, TYPE_TAG)){
				ptr = &buf[typeTagLen];
				while((token = strtok(ptr, " /\r\n:"))!= NULL) {
					memset(outbuf, 0, MAX_BUF_SIZE);
					snprintf(outbuf, MAX_BUF_SIZE, "%s", TYPESEARCH_TAG);
					inbufPtr = token;
					inbufSize = strlen(token);
					outbufPtr = &outbuf[strlen(TYPESEARCH_TAG)];
					outbufSize = sizeof(outbuf) - strlen(TYPESEARCH_TAG);
					iconv(codeSet, (ICONV_CONST char**)&inbufPtr, (size_t*)&inbufSize, &outbufPtr, (size_t*)&outbufSize);

					typeToken = new wxString(outbuf, conv);
					if( addSearchStr(typeToken) ) {
						WikiList* wikiList = search(typeToken->mb_str());
						addSearchList(typeToken, wikiList);
					}
					delete typeToken;
					ptr = NULL;
				}
			}
		}
		fclose(fp);
        cont = dir->GetNext(fileName);
	}
	delete dir;
	delete fileName;
	iconv_close(codeSet);
}

bool mnModel::normalSearch(char* tokenList[], FILE*fp, char* decodeFileNameBuf)
{
    char        buf[MAX_BUF_SIZE];
	bool        found;
	int         i;
   	while(1){
       	memset(buf, 0, MAX_BUF_SIZE);
        fread(buf, MAX_BUF_SIZE-1, 1, fp);
        if(buf[0] == 0) break;
		toLower(buf);
		found = TRUE;
		for(i = 0; tokenList[i] != NULL; i++){
			toLower(tokenList[i]);
			if(strstr((const char*)buf, (const char*)tokenList[i]) ||                 /* search in file context */
				strstr((const char*)decodeFileNameBuf, (const char*)tokenList[i]) ||  /* search in file name    */
				strcmp((const char*)tokenList[i], (const char*)ALLMEMO_TAG) == 0) {   /* SHOW  ALL MEMO         */
				found = TRUE;
			}
			else {
				found = FALSE;
				break;
			}
		}

		if(found){ /* all tokens found */
			break;
		}
        buf[0] = 0;
	}

	return found;
}

bool mnModel::typeSearch(char* typeStr, FILE*fp)
{
    char        buf[MAX_BUF_SIZE];
	bool        found;
	int         i;
	char*       typeToken;
	char        typeStrCopy[MAX_BUF_SIZE];

	snprintf(typeStrCopy, MAX_BUF_SIZE, "%s", typeStr);
   	while(1){
       	memset(buf, 0, MAX_BUF_SIZE);
        fgets(buf, MAX_BUF_SIZE, fp);
        if(buf[0] == 0) break;
		if(strstr((const char*)buf, TYPE_TAG)){  /* search TYPE line */
			typeToken = strtok(typeStrCopy, ":");
			typeToken = strtok(NULL, ":");    /* second field separated by colon(:) */
			if(typeToken == NULL) return false;
			toLower(typeToken);
			toLower(buf);
			if(strstr(buf, typeToken)) return true;
		}
	}
	return false;
}

bool mnModel::addSearchStr(wxString* searchStr)
{
	wxString *string;

	if(searchStrList->Index(searchStr->c_str()) == wxNOT_FOUND){
		string = new wxString(searchStr->c_str());
		searchStrList->Add(*string, 1);
		//searchStrList->Insert(*string, 0);
		return true;  /* Add */
	}
	return false; /* does'nt add because of duplicating */
}

void mnModel::addSearchList(wxString* searchStr, WikiList* list)
{
	wikiHash[*searchStr] = list;
}

void mnModel::removeSearchStr(wxString searchStr)
{
	if(searchStrList->Index(searchStr.c_str()) != wxNOT_FOUND) {
		searchStrList->Remove(searchStr.c_str());
		wikiHash[*searchStr] = NULL;
	}
}

void mnModel::modSearchStr(wxString* oldStr, wxString* newStr)
{
	int index;

	if((index = searchStrList->Index(oldStr->c_str())) != wxNOT_FOUND){
		wxString& itemStr = searchStrList->Item(index);
		itemStr.sprintf(wxT("%s"), newStr->c_str());
	}
}

void mnModel::clearSearchStrList()
{
	searchStrList->Clear();
}

void mnModel::clearSearchResultList()
{
	wikiHash.clear();
}

const wxString* mnModel::getWikiDataDir()
{
	return wikiDataDir;
}

const wxArrayString* mnModel::getSearchStrList()
{
	return searchStrList;
}

WikiData* mnModel::newWikiData()
{
	WikiData* data = new WikiData(wikiDataDir);

	return data;
}
const WikiList* mnModel::getSearchResultList(wxString* searchStr)
{
	return wikiHash[*searchStr];
}

/* add "addData's" clone. if already exist same data, overwrite it*/
void mnModel::addSearchResultList(wxString* searchStr, WikiData* addData)
{
	WikiList* wikiList = wikiHash[*searchStr];
	WikiList::Node* node;
	WikiData* data;

	if(wikiList == NULL) {
		MN_FATAL_ERROR(wxT("wikiList is null"));
		return;
	}

	node = wikiList->GetFirst();
	while(node) {
		data = node->GetData();
		if(data == addData) return;
		if( *(data->getSubject()) == *(addData->getOldSubject()) ) {
			if(wikiList->DeleteObject(data)) {
				//delete data; /* may be wrong.. */
				break;
			}
			else {
				MN_FATAL_ERROR(wxT("Can't find delete data"));
			}
		}
		node = node->GetNext();
	}
	WikiData* copy = new WikiData((wxString*)wikiDataDir, (wxString*)addData->getFileName());
	wikiList->Append(copy);
	wikiList->Sort(compWikiData);
}

bool mnModel::delSearchResultList(wxString* searchStr, WikiData* delData)
{
	WikiList* wikiList = wikiHash[*searchStr];
	WikiList::Node* node;
	WikiData* data;
	bool      found = false;

	if(wikiList == NULL) {
		MN_FATAL_ERROR(wxT("wikiList is null"));
		return false;
	}

	node = wikiList->GetFirst();
	while(node) {
		data = node->GetData();
		if(data == delData) {
			if(!wikiList->DeleteObject(data)) {
				MN_FATAL_ERROR(wxT("Can't find delete data"));
			}
			found = true;
			break;
		}
		else if( *(data->getSubject()) == *(delData->getOldSubject()) ) {
			if(wikiList->DeleteObject(data)) {
				//delete data;  /* may be wrong.. */
				found = true;
				break;
			}
			else {
				MN_FATAL_ERROR(wxT("Can't find delete data"));
			}
		}
		node = node->GetNext();
	}
	wikiList->Sort(compWikiData);
	return found;
}

/******* WikiData ************************/
WikiData::WikiData(wxString* dataDir, wxString* inFileName)
{
	FILE* fp;
    wxString    fullPathName;
	char* decodeStr;
	char  buf[MAX_BUF_SIZE];
	char* inbuf;
	int   inbufSize;
	char  outbuf[MAX_BUF_SIZE];
	char* outbufPtr = outbuf;
	int   outbufSize;
	wxCSConv conv(wxT(CODE_SET_SYSTEM));

	iconv_t codeSet = iconv_open(CODE_SET_SYSTEM, CODE_SET_EUC_JP);
	if(codeSet == (iconv_t)-1) {
		MN_FATAL_ERROR(wxT("failed iconv_open"));
	}

	text = NULL;
	memset(outbuf, 0, MAX_BUF_SIZE);
	fileName = new wxString(inFileName->mb_str(), conv);
	dataDirName = new wxString(dataDir->mb_str(), conv);
	decodeStr = decode(fileName->mb_str());
	inbufSize = strlen(decodeStr);
	outbufSize = sizeof(outbuf);
	iconv(codeSet, (ICONV_CONST char**)&decodeStr, (size_t*)&inbufSize, &outbufPtr, (size_t*)&outbufSize);
	subject  = new wxString((const char*)outbuf, conv);
	oldSubject  = new wxString((const char*)outbuf, conv);
	iconv_close(codeSet);

	date     = NULL;

    fullPathName = *dataDir + wxT("/") + *fileName;
	fp = fopen((const char*)fullPathName.mb_str(), "r");
	if(fp == NULL) {
		MN_FATAL_ERROR(wxT("fopen faild"));
	}
	while(fgets(buf, MAX_BUF_SIZE, fp)) {
		if(strstr( (const char*)buf, (const char*)DATE_TAG)) {
			strtok(buf, "\n");
			strtok(buf, "\r");
			date = new wxString((const char*)buf, conv);
			break;
		}
	}
	fclose(fp);
}

WikiData::WikiData(wxString* dataDir) {
	time_t     now;
	char       buf[MAX_BUF_SIZE];
	wxCSConv    conv(wxT(CODE_SET_SYSTEM));

	dataDirName = new wxString(dataDir->mb_str(), conv);

    time(&now);
	memset(buf, 0, sizeof(buf));
	strftime(buf, sizeof(buf), "%Y/%m/%d-%H%M%S",localtime(&now));
	subject  = new wxString(buf, conv);
	oldSubject  = new wxString(buf, conv);

	fileName = new wxString(encode(buf), conv);
	fileName->Append(wxT(EXT_TAG));

	memset(buf, 0, sizeof(buf));
	strftime(buf, sizeof(buf), DATE_TAG "%Y/%m/%d %H:%M:%S",localtime(&now));
	date    = new wxString(buf, conv);
	
	memset(buf, 0, sizeof(buf));
	strftime(buf, sizeof(buf), NEW_DATA,localtime(&now));
	text    = new wxString(buf, conv);

}

WikiData::~WikiData()
{
	delete subject;
	delete oldSubject;
	delete fileName;
	delete date;
	delete text;
	delete dataDirName;
}

const wxString* WikiData::getFileName() 
{
	return fileName;
}

const wxString* WikiData::getSubject() 
{
	return subject;
}

const wxString* WikiData::getOldSubject() 
{
	return oldSubject;
}

void WikiData::setOldSubjectFromCurrent() 
{
	oldSubject = new wxString(*subject);
}

void WikiData::modSubject(wxString* newSubject) 
{
	wxCSConv    conv(wxT(CODE_SET_SYSTEM));
	wxString*   oldFileName = fileName;
	char        oldFullPath[MAX_BUF_SIZE];
	char        newFullPath[MAX_BUF_SIZE];
	iconv_t     codeSet;
	char        outbuf[MAX_BUF_SIZE];
	char        inbuf[MAX_BUF_SIZE];
	const char* inbufPtr  = inbuf;
	char*       outbufPtr = outbuf;
	int         inbufSize;
	int         outbufSize = sizeof(outbuf);
	FILE*       fp;

	oldSubject = subject;

	memset(outbuf, 0, outbufSize);
	memset(inbuf,  0, sizeof(inbuf));
	strcpy(inbuf, (const char*)newSubject->mb_str());
	inbufSize = strlen(inbuf);
	codeSet = iconv_open(CODE_SET_EUC_JP, CODE_SET_SYSTEM);
	if(codeSet == (iconv_t)-1) {
		MN_FATAL_ERROR(wxT("failed iconv_open"));
	}
	iconv(codeSet, (ICONV_CONST char**)&inbufPtr, (size_t*)&inbufSize, &outbufPtr, (size_t*)&outbufSize);
	iconv_close(codeSet);
	subject  = new wxString(newSubject->c_str());
	fileName = new wxString(encode(outbuf), conv);
	fileName->Append(wxT(EXT_TAG));

	sprintf(oldFullPath, "%s/%s", (const char*)dataDirName->mb_str(), (const char*)oldFileName->mb_str());
	sprintf(newFullPath, "%s/%s", (const char*)dataDirName->mb_str(), (const char*)fileName->mb_str());

	if((fp = fopen(newFullPath, "r")) == NULL) {
		if(rename(oldFullPath, newFullPath) < 0) wxLogMessage(wxT("rename error: errno=[%d]"), errno);
	}
	else if(strcmp(oldFullPath, newFullPath)){
		wxLogMessage(wxT("File has already exist. [%s]"), fileName->c_str());
		fclose(fp);
	}
	else {
		fclose(fp);
	}

	delete oldFileName;
}

const wxString* WikiData::getDate() 
{
	return date;
}


const wxString* WikiData::getText() 
{
	FILE* fp;
	char  buf[MAX_BUF_SIZE];
	char  fullPath[MAX_BUF_SIZE];
	iconv_t     codeSet;
	char        outbuf[MAX_BUF_SIZE];
	char*       inbufPtr;
	char*       outbufPtr;
	int         inbufSize;
	int         outbufSize;
	wxCSConv    conv(wxT(CODE_SET_SYSTEM));
	wxString*   tmpStr;

	codeSet = iconv_open(CODE_SET_SYSTEM, CODE_SET_EUC_JP);
	if(codeSet == (iconv_t)-1) {
		MN_FATAL_ERROR(wxT("failed iconv_open"));
	}

	if(text) {
		iconv_close(codeSet);
		return text;
	}

	text = new wxString();
	sprintf(fullPath, "%s/%s", (const char*)dataDirName->mb_str(), (const char*)fileName->mb_str());
	fp = fopen(fullPath, "r");
	if(fp == NULL) {
		MN_FATAL_ERROR(wxT("File open error."));
	}

	while(fgets(buf, MAX_BUF_SIZE, fp)) {
#ifdef __WXMAC__
		for(int i = 0; buf[i] != 0; i++) if(buf[i] == (char)MAC_BACKSLASH) buf[i] = '\\';
#endif
		inbufPtr = buf;
		inbufSize = sizeof(buf);
		outbufPtr = outbuf;
		outbufSize = sizeof(outbuf);
		memset(outbuf, 0, outbufSize);
		iconv(codeSet, (ICONV_CONST char**)&inbufPtr, (size_t*)&inbufSize, &outbufPtr, (size_t*)&outbufSize);
		tmpStr = new wxString((char*)outbuf, conv);
		*text += *tmpStr;
		delete tmpStr;
	}
	iconv_close(codeSet);
	fclose(fp);

	return text;
}

void WikiData::modText(wxString* intext) 
{
	wxCSConv conv(wxT(CODE_SET_SYSTEM));
	delete text;
	//text = new wxString(intext->c_str());
	//text = new wxString(*intext);
	text = new wxString(intext->mb_str(), conv);
}

void WikiData::removeDataFile()
{
	char fullPath[MAX_BUF_SIZE];
	
	sprintf(fullPath, "%s/%s", (const char*)dataDirName->mb_str(), (const char*)fileName->mb_str());
	if(remove(fullPath)) {
		MN_FATAL_ERROR(wxT("remove file error"));
	}
}

void WikiData::save() 
{
	char fullPath[MAX_BUF_SIZE];
	FILE* fp;
	iconv_t     codeSet;
	char        inbuf[MAX_WIKI_TEXT_SIZE];
	char        outbuf[MAX_WIKI_TEXT_SIZE];
	const char*       inbufPtr;
	char*       outbufPtr;
	int         inbufSize;
	int         outbufSize;

	codeSet = iconv_open(CODE_SET_EUC_JP, CODE_SET_SYSTEM);
	if(codeSet == (iconv_t)-1) {
		MN_FATAL_ERROR(wxT("failed iconv_open"));
	}

	sprintf(fullPath, "%s/%s", (const char*)dataDirName->mb_str(), (const char*)fileName->mb_str());
	fp = fopen(fullPath, "wb");
	if(fp == NULL) {
		MN_FATAL_ERROR(wxT("File open error."));
	}

	memset(inbuf, 0, sizeof(inbuf));
	strcpy(inbuf,(const char*)text->mb_str());

#ifdef __WXMAC__
	for(int i = 0; inbuf[i] != 0; i++) if(inbuf[i] == (char)MAC_BACKSLASH) inbuf[i] = '\\';
#endif

	inbufPtr = inbuf;
	inbufSize = strlen(inbufPtr);
	outbufPtr = outbuf;
	outbufSize = sizeof(outbuf);
	memset(outbuf, 0, outbufSize);
	iconv(codeSet, (ICONV_CONST char**)&inbufPtr, (size_t*)&inbufSize, &outbufPtr, (size_t*)&outbufSize);
	fwrite(outbuf, sizeof(outbuf)-outbufSize, 1, fp);
	fclose(fp);
	iconv_close(codeSet);
}

/******* Tools ************************/

static void toLower(char* string)
{
	int i;

	for(i = 0; string[i] != 0; i++) {
		string[i] = tolower(string[i]);
	}
}


static char* decode(const char* string)
{
	static char buf[MAX_BUF_SIZE];
 	char c[5];
	int i,j;
	char* endPtr = NULL;

	j = 0;
	memset(buf, 0, MAX_BUF_SIZE);	
	for(i = 0; string[i] != 0; i+=2) {
		c[0] = '0'; c[1] = 'x';
		c[2] = string[i]; c[3] = string[i+1]; c[4] = 0;
		buf[j] = strtol(c, &endPtr, 0);
		j++;
		if(j >= MAX_BUF_SIZE) {
			buf[MAX_BUF_SIZE] = 0;
			break;
		}
	}

	return buf;
}

static char* encode(const char* string)
{
	static char buf[MAX_BUF_SIZE];
	int i,j;

	j = 0;
	memset(buf, 0, MAX_BUF_SIZE);
	for(i = 0; string[i] != 0; i++) {
		snprintf(&buf[j], 3, "%02X", (unsigned char)(string[i]));
		j+=2;
		if(j >= MAX_BUF_SIZE) {
			buf[MAX_BUF_SIZE] = 0;
			break;
		}
	}
	return buf;
}

/*
 *    wiki1 > wiki2   ->  return < 0
 *    wiki1 = wiki2   ->  return = 0
 *    wiki1 < wiki2   ->  return > 0
 */
static int compWikiData(const void* wiki1, const void* wiki2)
{
	WikiData* data1 = *(WikiData**)wiki1;
	WikiData* data2 = *(WikiData**)wiki2;
	const wxString* str1 = NULL;
	const wxString* str2 = NULL;

	str1 = data1->getDate();
	str2 = data2->getDate();

	if(str1 != NULL && str2 != NULL) {
		return (strcmp(str2->mb_str(), str1->mb_str()));
	}
	else{
		return 0;
	}
}

