// -*- C++ -*- generated by wxGlade 0.3.5.1 on Wed Jun 29 12:57:38 2005
#include <wx/regex.h>
#include <wx/tokenzr.h>
#include <wx/xrc/xmlres.h>
#include "mnID.h"
#include "mnDef.h"
#include "mnFrame.h"
#include "mnDialog.h"


mnFrame::mnFrame(wxWindow* parent)
{
	wxXmlResource::Get()->LoadFrame(this, parent, wxT("mnFrame"));

#ifdef __WXMSW__
    wxIcon icon(wxT(APP_ICON_NAME), wxBITMAP_TYPE_ICO_RESOURCE);
    SetIcon(icon);
#endif
    
	/* init members */
	searchTree       = XRCCTRL(*this, "searchTree", wxTreeCtrl);
	searchTextCtrl   = XRCCTRL(*this, "searchTextCtrl", wxTextCtrl);
	wikiHtmlTextCtrl = XRCCTRL(*this, "wikiHtmlTextCtrl", mnHtmlWindow);

	/* create search tree */
	searchItemRoot = searchTree->AddRoot(wxT(LABEL_ITEM_TREE), -1, -1, NULL);
}

void mnFrame::updateSearchResult(mnModel* wiki, wxString* searchStr, bool isExpand)
{
	wxTreeItemIdValue cookie1, cookie2;
	wxTreeItemId      searchStrId;
	wxTreeItemId      wikiDataId;
	const WikiList* wikiList;
	WikiList::Node* node;
	WikiData*       data;
	const wxString* subject;

	memset(&cookie1, 1, sizeof(cookie1));
	memset(&cookie2, 2, sizeof(cookie2));
	searchStrId = searchTree->GetFirstChild(searchItemRoot, cookie1);
	while(searchStrId.IsOk()) {
		if(searchTree->GetItemText(searchStrId) == *searchStr) {
			wikiDataId = searchTree->GetFirstChild(searchStrId, cookie2);
			while(wikiDataId.IsOk()) {
				searchTree->SetItemData(wikiDataId, NULL);
				wikiDataId = searchTree->GetNextChild(searchStrId, cookie2);
			}
			searchTree->DeleteChildren(searchStrId);
			break;
		}		
		searchStrId = searchTree->GetNextChild(searchItemRoot, cookie1);
	}

	wikiList = wiki->getSearchResultList(searchStr);
	if(wikiList == NULL) {
		MN_FATAL_ERROR(wxT("wikiList is null"));
		return;
	}

	node = wikiList->GetFirst();
	while(node) {
		data = node->GetData();
		subject = data->getSubject();
		searchTree->AppendItem(searchStrId, *subject, -1, -1, (wxTreeItemData*)data);
		node = node->GetNext();
	}
	if(isExpand){
	   	searchTree->Expand(searchStrId);
	}
	else {
	   	searchTree->Collapse(searchStrId);
	}
}

void mnFrame::addSearchResult(mnModel* wiki, wxString* searchStr, bool isExpand)
{
	wxTreeItemId    searchItem;
	const WikiList* wikiList;
	WikiList::Node* node;
	WikiData*       data;
	const wxString* subject;

	wikiList = wiki->getSearchResultList(searchStr);
	if(wikiList == NULL) {
		MN_FATAL_ERROR(wxT("wikiList is null"));
		return;
	}

	//searchItem = searchTree->AppendItem(searchItemRoot, *searchStr, -1, -1, NULL);
	searchItem = searchTree->InsertItem(searchItemRoot, 0, *searchStr, -1, -1, NULL);
	node = wikiList->GetFirst();
	while(node) {
		data = node->GetData();
		subject = data->getSubject();
		searchTree->AppendItem(searchItem, *subject, -1, -1, (wxTreeItemData*)data);
		node = node->GetNext();
	}

	searchTree->Expand(searchItemRoot);
	if(isExpand){
	   	searchTree->Expand(searchItem);
	}
	else {
	   	searchTree->Collapse(searchItem);
	}
}

void mnFrame::makeHtml(WikiData* wikiData, bool isHighlight)
{
	const wxString* fileName = wikiData->getFileName();
	const wxString* wikiText = wikiData->getText();
	wxString htmlText(*wikiText);

	/* escape < */
	wxRegEx exp01(wxT("<"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp01.Replace(&htmlText, wxT("\\&lt "));

	/* escape > */
	wxRegEx exp02(wxT(">"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp02.Replace(&htmlText, wxT("\\&gt "));
	
	/* [[ ]] */
	wxRegEx exp1(wxT("\\[\\[([^\\}]+)\\]\\]"));
	exp1.Replace(&htmlText, wxT("<a href=mnlink:\\1>\\1</a>"));

 	/* http://  */	
	wxRegEx exp2(wxT("(http://[-_.!~*'a-zA-Z0-9;/?:@&=+$,%#]+)"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp2.Replace(&htmlText, wxT("<a href=\\1>\\1</a>"));

 	/* file://  */	
	wxRegEx exp3(wxT("(file://[^ ]+)"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp3.Replace(&htmlText, wxT("<a href=\\1>\\1</a>"));

	/* *XXXX */
	wxRegEx exp4(wxT("^\\*([^\\*]+)"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp4.Replace(&htmlText, wxT("<h3>\\1</h3>"));
	
	/* **XXXX */
	wxRegEx exp5(wxT("^\\*\\*([^\\*]+)"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp5.Replace(&htmlText, wxT("<h4>\\1</h4>"));
	
	/* :''XXXX'': */
	wxRegEx exp6(wxT("^:''(.+)'':(.+)"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp6.Replace(&htmlText, wxT("<u><b>\\1:\\2</b></u>"));

	/* ---- */
	wxRegEx exp7(wxT("^----.*"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp7.Replace(&htmlText, wxT("<hr>"));

	/* {{ }} */
	wxRegEx exp8(wxT("\\{\\{([^\\}]+)\\}\\}"));
	exp8.Replace(&htmlText, wxT("<a href=mndoc:\\1>\\1</a>"));

	/* table */
	wxRegEx exp10(wxT(",([^,\n]+)"), wxRE_DEFAULT);
	exp10.Replace(&htmlText, wxT("<td>\\1</td>"));
	wxRegEx exp11(wxT("^<td>"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp11.Replace(&htmlText, wxT("<tr><td>"));
	wxRegEx exp12(wxT("</td>$"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp12.Replace(&htmlText, wxT("</td></tr>"));
	wxRegEx exp15(wxT("</tr>\n"));
	exp15.Replace(&htmlText, wxT("</tr>"));

	wxRegEx exp13(wxT("^<tr>"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp13.Replace(&htmlText, wxT("<table border><tr>"));
	wxRegEx exp14(wxT("</tr>$"), wxRE_NEWLINE|wxRE_DEFAULT);
	exp14.Replace(&htmlText, wxT("</tr></table>"));

	
	/* Highlight search text */
	highlight = isHighlight;
	if(isHighlight) {
        wxTreeItemId parentId = searchTree->GetItemParent(searchTree->GetSelection());
		wxString     searchWords = searchTree->GetItemText(parentId);
		wxStringTokenizer tkz(searchWords, wxT(" "));
		while ( tkz.HasMoreTokens() )
		{
			wxString token = tkz.GetNextToken();
			wxRegEx exp9(wxT("(?!<[^>]+)(") + token + wxT(")(?![^<]+>)"), wxRE_ADVANCED|wxRE_ICASE|wxRE_NEWLINE);
			exp9.Replace(&htmlText, wxT("<b><font color=\"red\">\\1</font></b>"));
		}
	}

	
	/* make HTML document */
	wxString wikiHtml;
	wikiHtml.Append(wxT("<meta http-equiv=\"Content-Type\"content=\"text/html; charset="));
	wikiHtml.Append(wxT(CODE_SET_SYSTEM));
	wikiHtml.Append(wxT("\">"));
	wikiHtml.Append(wxT("<pre>"));
	wikiHtml.Append(htmlText);
	wikiHtml.Append(wxT("</pre>"));

	wikiHtmlTextCtrl->SetPage(wikiHtml);
}

void mnFrame::showSelectedItemText(wxTreeEvent& event)
{
	wxTreeItemId    id;
	wxTreeItemData* item;

	id = searchTree->GetSelection();
	item = searchTree->GetItemData(id);

	if(!id.IsOk() || !isEditableTreeLabel(id) || item == NULL) { /* selection is not memo data */
		wikiHtmlTextCtrl->SetPage(wxT(""));
		return;
	}
	makeHtml((WikiData*)item, false);
}

wxTreeItemId mnFrame::getSelection()
{
	return searchTree->GetSelection();
}

void mnFrame::highlightSelectedItem()
{
	wxTreeItemData* item    = getSelectedItem();
	
	if(!isEditableTreeLabel(searchTree->GetSelection())) { /* selection is not memo data */
		wikiHtmlTextCtrl->SetPage(wxT(""));
		return;
	}

	if(highlight){
		makeHtml((WikiData*)item, false);
	}
	else {
		makeHtml((WikiData*)item, true);
	}
}

void mnFrame::expandAllTree()
{
	wxTreeItemIdValue cookie;
	wxTreeItemId      itemId;

	memset(&cookie, 1, sizeof(cookie));
	itemId = searchTree->GetFirstChild(searchItemRoot, cookie);
	while(itemId.IsOk()) {
		searchTree->Expand(itemId);	
		itemId = searchTree->GetNextChild(searchItemRoot, cookie);
	}
}

void mnFrame::collapseAllTree()
{
	wxTreeItemIdValue cookie;
	wxTreeItemId      itemId;

	memset(&cookie, 1, sizeof(cookie));
	itemId = searchTree->GetFirstChild(searchItemRoot, cookie);
	while(itemId.IsOk()) {
		searchTree->Collapse(itemId);	
		itemId = searchTree->GetNextChild(searchItemRoot, cookie);
	}
}

void mnFrame::clearAllTree()
{
	wxTreeItemIdValue cookie1, cookie2;
	wxTreeItemId      searchStrId;
	wxTreeItemId      wikiDataId;

	memset(&cookie1, 1, sizeof(cookie1));
	memset(&cookie2, 2, sizeof(cookie2));
	searchStrId = searchTree->GetFirstChild(searchItemRoot, cookie1);
	while(searchStrId.IsOk()) {
		wikiDataId = searchTree->GetFirstChild(searchStrId, cookie2);
		while(wikiDataId.IsOk()) {
			searchTree->SetItemData(wikiDataId, NULL);
			wikiDataId = searchTree->GetNextChild(searchStrId, cookie2);
		}
		searchStrId = searchTree->GetNextChild(searchItemRoot, cookie1);
	}

	searchTree->DeleteChildren(searchItemRoot);
}

void mnFrame::removeSelectedItem()
{
	searchTree->Delete(searchTree->GetSelection());
}

wxTreeItemData* mnFrame::getSelectedItem()
{
	return searchTree->GetItemData(searchTree->GetSelection());
}

wxString mnFrame::getSelectedLabel()
{
	return searchTree->GetItemText(searchTree->GetSelection());
}

bool mnFrame::isEditableTreeLabel(wxTreeItemId id)
{
	if(id.IsOk()){ 
		return !(searchTree->GetItemParent(id) == searchItemRoot || id == searchItemRoot);
	}
	else {
		return false;
	}
}

