// -*- C++ -*- generated by wxGlade 0.3.5.1 on Wed Jun 29 12:57:38 2005

#include "mnID.h"
#include "mnDef.h"
#include "mnController.h"
#include <wx/config.h>
#include <wx/tokenzr.h>
#include <wx/utils.h>
#include <wx/xrc/xmlres.h>

BEGIN_EVENT_TABLE(mnController, wxEvtHandler)
	EVT_TEXT_ENTER(XRCID("searchTextCtrl"), mnController::handleSearch)
	EVT_TREE_SEL_CHANGED(XRCID("searchTree"), mnController::handleTreeItemSelect)
	EVT_TREE_SEL_CHANGING(XRCID("searchTree"), mnController::handleTreeItemSelecting)
	EVT_TREE_BEGIN_LABEL_EDIT(XRCID("searchTree"), mnController::handleBeginLabelEdit)
	EVT_TREE_END_LABEL_EDIT(XRCID("searchTree"), mnController::handleEndLabelEdit)
	EVT_MENU(XRCID("New"), mnController::handleNewButton)
	EVT_MENU(XRCID("Remove"), mnController::handleRemoveButton)
	EVT_MENU(XRCID("Highlight"), mnController::handleHighlightButton)
	EVT_MENU(XRCID("Edit"), mnController::handleEditButton)
	EVT_MENU(XRCID("Quit"), mnController::handleExit)
	EVT_MENU(XRCID("Configure"), mnController::handleConfig)
	EVT_MENU(XRCID("Group"), mnController::handleGroup)
	EVT_MENU(XRCID("OpenDocsDir"), mnController::handleOpenDocsDir)
	EVT_MENU(XRCID("Expand"), mnController::handleTreeExpand)
	EVT_MENU(XRCID("Collapse"), mnController::handleTreeCollapse)
	EVT_MENU(XRCID("Clear"), mnController::handleTreeClear)
	EVT_MENU(wxID_ABOUT, mnController::handleAbout)
	EVT_CLOSE(mnController::handleClose)
	EVT_COMMAND(XRCID("wikiHtmlTextCtrl"), mnEVT_LINK_CLICK, mnController::handleLinkClick)
END_EVENT_TABLE()

mnController::mnController(mnFrame* inframe)
{
	wxString* dirName = new wxString();
	wxString gotDirName;
	wxDirDialog* dlg;

	frame = inframe;

	/* create wiki model */
	wxConfig* config = new wxConfig(wxT(CONF_APP_NAME));
	if(config->Read(wxT(CONF_WIKI_DIR), dirName) == FALSE) {
		delete dirName;
		dlg = new wxDirDialog(frame);
		if(dlg->ShowModal() == wxID_OK) {
			gotDirName = dlg->GetPath();
			wiki = new mnModel(gotDirName.mb_str());
			config->Write(wxT(CONF_WIKI_DIR), gotDirName.c_str());
		}
		else {
			frame->Close();
		}
	}
	else {
		wiki = new mnModel(dirName->mb_str());
	}

	delete config;
}

void mnController::handleConfig(wxCommandEvent& event)
{
	wxDirDialog* dlg;
	wxString gotDirName;
	wxString* dirName = new wxString();

	wxConfig* config = new wxConfig(wxT(CONF_APP_NAME));

	if(config->Read(wxT(CONF_WIKI_DIR), dirName)) {
		if(wxMessageBox(*dirName, wxT("Change data directory?"), wxYES_NO|wxICON_QUESTION) == wxNO){
			delete config;
			return;
		}
	}	

	dlg = new wxDirDialog(frame);
	if(dlg->ShowModal() == wxID_OK) {
		gotDirName = dlg->GetPath();
		delete wiki;
		wiki = new mnModel(gotDirName.mb_str());
		config->Write(wxT(CONF_WIKI_DIR), gotDirName.c_str());
	}
	delete config;

	frame->clearAllTree();
}

void mnController::handleSearch(wxCommandEvent& event)
{
	wxString* str = new wxString(event.GetString());
	WikiList*       wikiList;
	WikiList::Node* node;

	wikiList = wiki->search(str->mb_str());

	node = wikiList->GetFirst();
	if(!node) {
		wxLogMessage(wxT("Not Found! [%s]"), (const char*)str->c_str());
		return;
	}

	if(wiki->addSearchStr(str)) {
		wiki->addSearchList(str, wikiList);
		frame->addSearchResult(wiki, str);
	}
	else { /* str is already in search list */
		delete wikiList;
	}
}

void mnController::handleGroup(wxCommandEvent& event)
{
	WikiList*       wikiList;
	const wxArrayString*  searchStrList;
	int i;
	wxCursor normal;
	wxCursor watch(wxCURSOR_WATCH);

	frame->SetCursor(watch);
	wiki->group();
	frame->clearAllTree();
	searchStrList = wiki->getSearchStrList();
	for(i = 0; i < searchStrList->Count(); i++) {
		wxString& searchStr = searchStrList->Item(i);
		frame->addSearchResult(wiki, &searchStr);
	}
	frame->SetCursor(normal);
}


void mnController::handleNewButton(wxCommandEvent& event)
{
	int             ans;
	WikiData* wikiData = wiki->newWikiData();
	wxString        plainTextStr;
	wxString        newSubjectStr;
	mnWikiDataEntryDialog* dlg = new mnWikiDataEntryDialog(frame);
	const wxString* wikiText = wikiData->getText();
	const wxString* subject  = wikiData->getSubject();

	dlg->setSubject(*subject);
	dlg->setPlainText(*wikiText);
	ans = dlg->ShowModal();

	if(ans != wxID_OK) return ;

	plainTextStr = dlg->getPlainText();
	newSubjectStr   = dlg->getSubject();
	wikiData->modText(&plainTextStr);
	wikiData->save();

	wikiData->modSubject(&newSubjectStr);

	notifyUpdate(wikiData);
	
	delete dlg;
}

void mnController::handleRemoveButton(wxCommandEvent& event)
{
	wxTreeItemData* item = frame->getSelectedItem();

	if(frame->isEditableTreeLabel(frame->getSelection())) { 
		if(wxMessageBox(wxT("Do you realy remove this memo?\n") + frame->getSelectedLabel(), wxT("Realy?"), wxYES_NO|wxICON_QUESTION) == wxYES){
			((WikiData*)(item))->removeDataFile();
			notifyUpdate((WikiData*)(item));
		}
		else {
			return;
		}
	}
	else {
		wiki->removeSearchStr(frame->getSelectedLabel());
		frame->removeSelectedItem();
	}

}

void mnController::handleHighlightButton(wxCommandEvent& event)
{
	frame->highlightSelectedItem();
}


void mnController::handleTreeItemSelect(wxTreeEvent& event)
{
	frame->showSelectedItemText(event);
}


void mnController::handleTreeItemSelecting(wxTreeEvent& event)
{
}

void mnController::handleBeginLabelEdit(wxTreeEvent& event)
{
	if(!frame->isEditableTreeLabel(event.GetItem())) event.Veto();
}

void mnController::handleEndLabelEdit(wxTreeEvent& event)
{
	wxString newSubject   = event.GetLabel();
	wxTreeItemData* item  = frame->getSelectedItem();

	if(item == NULL) {
		return ;
	}
	
	if(newSubject.Len() == 0) {
		event.Veto();
		return;
	}

	((WikiData*)(item))->modSubject(&newSubject);

	event.Veto();

	notifyUpdate((WikiData*)item);
}

void mnController::handleClose(wxCloseEvent& event)
{
	frame->Destroy();
}

void mnController::handleExit(wxCommandEvent& event)
{
	frame->Close();
}

void mnController::handleTreeExpand(wxCommandEvent& event)
{
	frame->expandAllTree();
}

void mnController::handleTreeCollapse(wxCommandEvent& event)
{
	frame->collapseAllTree();
}

void mnController::handleTreeClear(wxCommandEvent& event)
{
	wiki->clearSearchStrList();
	wiki->clearSearchResultList();
	frame->clearAllTree();
}

void mnController::handleAbout(wxCommandEvent& event)
{
	wxMessageBox(wxT(MN_APP_VERSION), wxT("Abount MalonNote"), wxOK|wxICON_INFORMATION);
}


void mnController::handleEditButton(wxCommandEvent& event)
{
	wxString        plainTextStr;
	wxString        newSubjectStr;
	wxTreeItemData* itemData = frame->getSelectedItem();
	wxString        subject  = frame->getSelectedLabel();
	mnWikiDataEntryDialog* dlg = new mnWikiDataEntryDialog(frame);
	int             ans;

	if(!frame->isEditableTreeLabel(frame->getSelection())) return; /* selection is not memo data */

	const wxString* wikiText = ((WikiData*)(itemData))->getText();

	dlg->setSubject(subject);
	dlg->setPlainText(*wikiText);
	ans = dlg->ShowModal();

	if(ans != wxID_OK) return ;
	if(itemData == NULL) return ;

	plainTextStr = dlg->getPlainText();
	newSubjectStr   = dlg->getSubject();
	((WikiData*)(itemData))->modText(&plainTextStr);
	((WikiData*)(itemData))->save();

	((WikiData*)(itemData))->modSubject(&newSubjectStr);

	notifyUpdate((WikiData*)itemData);

	delete dlg;
}

void mnController::notifyUpdate(WikiData* data)
{
	const wxArrayString*  searchStrList= wiki->getSearchStrList();
	char*  tokenList[32];

	memset(tokenList, 0, sizeof(char*)*32);
	for(int i = 0; i < searchStrList->Count(); i++) {
		wxString& searchStr = searchStrList->Item(i);
		if( wiki->makeSearchToken(searchStr.mb_str(), tokenList) ) { /* create token */
			if(wiki->matchWithToken((wxString*)(data->getFileName()), tokenList)) { /* match */
				wiki->addSearchResultList(&searchStr, data);
				frame->updateSearchResult(wiki, &searchStr);
			}
			else {                                                                  /* not match */
				if( wiki->delSearchResultList(&searchStr, data) ) { 
					frame->updateSearchResult(wiki, &searchStr); /* only when suceed to delete */
				}
			}
			for(int j = 0; tokenList[j] != NULL; j++) free(tokenList[j]);
			memset(tokenList, 0, sizeof(char*)*32);
		}
	}
	data->setOldSubjectFromCurrent(); // restore old subject
}

void mnController::handleLinkClick(wxCommandEvent &event)
{
	const wxString* wikiDataDir;
	wxString href = event.GetString();
	wxString tag;
	wxString val;
	wxString doc;
	wxStringTokenizer tkz(href, wxT(":"));

	tag = tkz.GetNextToken();	
	val = tkz.GetNextToken();
	if(tag.CmpNoCase(wxT("mnlink")) == 0) {
		event.SetString(val);
		handleSearch(event);
	}
	else if(tag.CmpNoCase(wxT("mndoc")) == 0) {
		wikiDataDir = wiki->getWikiDataDir();
		doc = *wikiDataDir + wxT("/docs/") + val;
		openDoc(doc);
	}
	else {
		openUrl(href);
	}
}

void mnController::handleOpenDocsDir(wxCommandEvent &event)
{
	const wxString* wikiDataDir;
	wxString cmd;
	wxString docDir;

	wikiDataDir = wiki->getWikiDataDir();
	docDir = *wikiDataDir + wxT("/docs/");

	/* create docs directory, anyway */
	cmd.sprintf(wxT("mkdir "), docDir.c_str());
	wxExecute(cmd);

	/* open docs directory */
	openDoc(docDir);
}

void mnController::openUrl(wxString& url)
{
	wxString cmd;

#ifdef __WXMSW__
	cmd.sprintf(wxT("cmd /c \"start %s\""), url.c_str());
#endif

#ifdef __WXMAC__
	cmd.sprintf(wxT("open %s"), url.c_str());
#endif

#ifdef __WXCOCOA__
	cmd.sprintf(wxT("open %s"), url.c_str());
#endif

#ifdef __WXGTK__
	cmd.sprintf(wxT("gnome-open %s"), url.c_str());
#endif

	//wxExecute(argv);
	wxExecute(cmd);
}

void mnController::openDoc(wxString& doc)
{
	wxString cmd;

#ifdef __WXMSW__
	cmd.sprintf(wxT("cmd /c \"start %s\""), doc.c_str());
#endif

#ifdef __WXMAC__
	cmd.sprintf(wxT("open %s"), doc.c_str());
#endif

#ifdef __WXCOCOA__
	cmd.sprintf(wxT("open %s"), doc.c_str());
#endif

#ifdef __WXGTK__
	cmd.sprintf(wxT("gnome-open %s"), doc.c_str());
#endif

	wxExecute(cmd);
}
