// -*- C++ -*- generated by wxGlade 0.3.5.1 on Wed Jun 29 12:57:38 2005

#include <wx/wx.h>
#include <wx/image.h>
#include <wx/snglinst.h>
#include <wx/xrc/xmlres.h>
#include "mnDef.h"
#include "mnFrame.h"
#include "mnController.h"

extern void InitXmlResource(); // defined in mnResource.cpp generated by wxrc

class mnApp: public wxApp {
public:
    bool OnInit();
	int OnExit();

private:
	mnFrame* mainFrame;
	wxSingleInstanceChecker* m_checker;
};

IMPLEMENT_APP(mnApp)

//static wxLocale locale(wxLANGUAGE_DEFAULT);

bool mnApp::OnInit()
{
	
	const wxString appName = wxString::Format(wxT(MN_APP_NAME) wxT("-%s"), wxGetUserId().c_str());

    m_checker = new wxSingleInstanceChecker(appName);
    if ( m_checker->IsAnotherRunning() ){
        wxMessageBox(wxT("Another program instance is already running, aborting."));
		delete m_checker;
		exit(0);
    }

    wxInitAllImageHandlers();
	wxXmlResource::Get()->InitAllHandlers();
	InitXmlResource();

    mainFrame = new mnFrame(0);

	/* set controller object as event handler */
	mnController* controller = new mnController(mainFrame);
	mainFrame->PushEventHandler(controller);

    SetTopWindow(mainFrame);
    mainFrame->Show();

    return true;
}

int mnApp::OnExit() 
{
	delete m_checker;
}
