<?php
defined('_JEXEC') or die;

// Create alias for $this object reference:
$document = $this;

// Shortcut for template base url:
$templateUrl = $document->baseurl . '/templates/' . $document->template;

?>
<!DOCTYPE html>
<html dir="ltr" lang="<?php echo $document->language; ?>">
<head>
    <jdoc:include type="head" />
	<link rel="stylesheet" href="<?php echo $templateUrl; ?>/css/bootstrap.min.css" media="screen">
	<link rel="stylesheet" href="<?php echo $templateUrl; ?>/css/style.css" media="screen">
	
	<link href="<?php echo $templateUrl; ?>/css/font-awesome.min.css" rel="stylesheet" type="text/css">
	<link href="https://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,800italic,400,300,600,700,800" rel="stylesheet" type="text/css">
	<link href="https://fonts.googleapis.com/css?family=Merriweather:400,300,300italic,400italic,700,700italic,900,900italic" rel="stylesheet" type="text/css">
	<link href="<?php echo $templateUrl; ?>/css/magnific-popup.css" rel="stylesheet">
	<link href="<?php echo $templateUrl; ?>/css/creative.css" rel="stylesheet">
	<?php global $gPageManager;if ($gPageManager->isLayout()): ?>
	<link rel="stylesheet" href="<?php echo $templateUrl; ?>/css/style_layout.css" media="screen">
	<?php endif; ?>
	<!--[if lt IE 9]>
	<script src="//oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
	<script src="//oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
	<![endif]-->
	<script src="<?php echo $templateUrl; ?>/bootstrap.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.3/jquery.easing.min.js"></script>
    <script src="<?php echo $templateUrl; ?>/js/scrollreveal.js"></script>
    <script src="<?php echo $templateUrl; ?>/js/jquery.magnific-popup.js"></script>
    <script src="<?php echo $templateUrl; ?>/js/creative.js"></script>
</head>
<body id="page-top">
    <nav id="mainNav" class="navbar navbar-default navbar-fixed-top">
        <div class="container-fluid">
            <!-- Brand and toggle get grouped for better mobile display -->
            <div class="navbar-header">
			    <jdoc:include type="modules" name="menu-title" style="boottitle" />
				<jdoc:include type="modules" name="brand" style="bootbrand" />
            </div>

            <!-- Collect the nav links, forms, and other content for toggling -->
            <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
				<jdoc:include type="navmenu" name="hmenu" />
            </div>
            <!-- /.navbar-collapse -->
        </div>
        <!-- /.container-fluid -->
    </nav>

    <header>
        <div class="header-content">
            <div class="header-content-inner">
				<jdoc:include type="modules" name="header" style="bootheader" />
				<jdoc:include type="modules" name="header-button" style="bootheaderbutton" />
            </div>
        </div>
    </header>

    <section class="bg-primary" id="about">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 col-lg-offset-2 text-center">
                    <jdoc:include type="modules" name="about" style="bootabout" />
					<jdoc:include type="modules" name="about-button" style="bootaboutbutton" />
                </div>
            </div>
        </div>
    </section>

    <section id="services">
    <jdoc:include type="modules" name="services" style="bootservice" />
	<jdoc:include type="modules" name="services-body" style="bootservicebody" />
	</section>

    <section class="no-padding" id="portfolio">
        <jdoc:include type="modules" name="portfolio" style="bootportfolio" />
    </section>
	
    <?php if ($document->countModules('others')): ?>
    <jdoc:include type="modules" name="others" style="bootother" />
    <?php endif; ?>
	
    <section id="contact">
        <div class="container">
            <div class="row">
			    <jdoc:include type="modules" name="contact" style="bootcontact" />
				<jdoc:include type="modules" name="contact-body" style="bootcontactbody" />
            </div>
        </div>
    </section>
    
    <!-- Footer -->
	<?php if ($document->countModules('footer')): ?>
    <footer>
        <div class="container text-center">
            <jdoc:include type="modules" name="footer" style="none" />
        </div>
    </footer>
	<?php endif; ?>

</body>
</html>