<?php
require_once('sonots/sonots.class.php');   // sonots' func collection
require_once('sonots/option.class.php');   // option parser func collection
require_once('sonots/pagelist.class.php'); // pagelist class
require_once('sonots/metapage.class.php'); // pagelist requires
require_once('sonots/tag.class.php');      // tag option
//error_reporting(E_ALL);

/**
 * Popular Plugin eXtension
 *
 * @package    plugin
 * @license    http://www.gnu.org/licenses/gpl.html GPL v2
 * @author     sonots <http://lsx.sourceforge.jp>
 * @link       http://lsx.sourceforge.jp/?Plugin%2Flsx.inc.php
 * @version    $Id: popularx.inc.php,v 2.0 2008-06-10 07:23:17Z sonots $
 * @require    sonots/sonots     v 1.9
 * @require    sonots/option     v 1.5
 * @require    sonots/pagelist   v 1.2
 * @require    sonots/metapage   v 1.6
 * @require    sonots/tag        v 1.0
 */

class PluginPopulary
{
    function PluginPopulary()
    {
        // Configure options
        // array(type, default, config)
        static $conf_options = array(
            'popular'   => array('enum', 'today', array('total', 'yesterday', 'today', 'recent')),
            'num'       => array('interval', '1:10'),
            'non_list'  => array('bool', true),
            'filter'    => array('string', null),
            'except'    => array('string', null),
            'reverse'   => array('bool', false), 
            'tree'      => array('enum', false, array(false, 'leaf', 'dir')),
            'next'      => array('bool', false),
            'linkstr'   => array('enum', 'pagename', array('name', 'pagename', 'absolute', 'basename', 'title', 'headline')),
            'newpage'   => array('enum', null, array('on', 'except')),
        );
        $this->conf_options    = &$conf_options;

        if (extension_loaded('mbstring')) {
            mb_regex_encoding(SOURCE_ENCODING);
        }
    }
    
    // static
    var $conf_options;
    var $plugin = "populary";
    // var

    /**
     * Block Plugin Main Function
     */
    function convert()
    {
        sonots::init_myerror(); do {
            $args = func_get_args();
            $line = csv_implode(',', $args);
            $options = PluginSonotsOption::parse_option_line($line);
            list($options, $unknowns) = PluginSonotsOption::evaluate_options($options, $this->conf_options);
            $options = PluginPopulary::check_options($options, $unknowns, $this->conf_options);
            if (sonots::mycatch()) break;

            $pages = get_existpages();
            $html = PluginPopulary::pagelist($pages, $options, $this->conf_options);
            return $html;
        } while (false);
        if (sonots::mycatch()) {
            return '<p>#populary(): ' . sonots::mycatch() . '</p>';
        }
    }

    /**
     * Action Plugin Main Function
     */
    function action()
    {
        sonots::init_myerror(); do {
            global $vars;
            $options = $vars;
            list($options, $unknowns) = PluginSonotsOption::evaluate_options($options, $this->conf_options);
            $options = PluginPopulary::check_options($options, array(), $this->conf_options);
            if (sonots::mycatch()) break;

            $pages = get_existpages();
            $title = $this->plugin;
            $html = PluginPopulary::pagelist($pages, $options, $this->conf_options);
            return array('msg'=>$title, 'body'=>$html);
        } while(false);
        if (sonots::mycatch()) {
            return array('msg'=>$this->plugin, 'body'=>'<p>' . sonots::mycatch() . '</p>');
        }
    }

    /**
     * Check option validities and compatibilities
     *
     * @param array $options
     * @param array $unknown unknown options
     * @param array $conf_options
     * @return array
     */
    function check_options($options, $unknowns, $conf_options)
    {
        global $vars;

        // first arg
        if (count($unknowns) > 0) {
            $unknown_keys = array_diff_key($unknowns, $conf_options);
            $key = key($unknown_keys);
            if (in_array($key, $conf_options['popular'][2])) {
                $options['popular'] = $key;
                unset($unknowns[$key]);
            }
        }
        if (count($unknowns) > 0) {
          $line = PluginSonotsOption::glue_option_line($unknowns);
          sonots::mythrow('Argument(s) "' . htmlspecialchars($line) . '" are invalid');
          return;
        }

        return $options;
    }

    /**
     * List pages
     *
     * @param array $pages
     * @param array $options
     * @param array $conf_options
     * @return string html
     */
    function pagelist($pages, $options, $conf_options)
    {
        $pagelist = new PluginSonotsPagelist($pages);
        $mb = extension_loaded('mbstring') ? 'mb_' : '';

        if ($options['non_list']) {
            $pattern = '/' . $GLOBALS['non_list'] . '/';
            $pagelist->grep_by('page', 'preg', $pattern, true); // inverse
        }
        if (isset($options['filter']) && $options['filter'] !== '') {
            $pagelist->grep_by('relname', $mb . 'ereg', $options['filter']);
        }
        if (isset($options['except'])) {
            $pagelist->grep_by('relname', $mb . 'ereg', $options['except'], true); // inverse
        }
        if (isset($options['newpage'])) {
            switch ($options['newpage']) {
            case 'on':
                $pagelist->set_metas('newpage');
                $pagelist->grep_by('newpage', 'eq', true);
                break;
            case 'except':
                $pagelist->set_metas('newpage');
                $pagelist->grep_by('newpage', 'eq', false);
                break;
            default:
                break;
            }
        }
        
        if (isset($options['popular'])) {
            $pagelist->set_metas('popular', array($options['popular']));
            $pagelist->sort_by('popular', $options['reverse']);
        }
        
        if (is_array($options['num'])) {
            list($offset, $length) = $options['num'];
            $pagelist->slice($offset, $length);
        }
        
        //////// display list
        
        $pagelist->set_metas('linkstr', array($options['linkstr']));
        $linkstrs = $pagelist->get_metas('linkstr');
        $pages    = $pagelist->get_metas('page');
        $counts   = $pagelist->get_metas('popular');
        $links    = $this->get_popular_links($pages, $linkstrs, $counts, $GLOBALS['var']['page']);
        $levels   = array();
        foreach ($links as $i => $tmp) {
            $levels[$i] = 1;
        }
        $html = sonots::display_list($links, $levels, 'populary');
        
        // prev next
        if ($options['next'] && is_array($options['num'])) {
            $basehref = get_script_uri() . '?cmd=populary';
            foreach ($options as $key => $val) {
                // add only user-input (non-default) option values
                if ($conf_options[$key][1] != $val) {
                    $basehref .= '&' . rawurlencode($key) 
                        . '='. rawurlencode(sonots::array_to_string((array)$val));
                }
            }
            $basehref = htmlspecialchars($basehref);
            list($offset, $length) = $options['num'];
            $entire   = array(1, count($pagelist->metapages));
            $interval = PluginSonotsOption::conv_interval($offset, $length, $entire[0], $entire[1]);
            $html .= $pagelist->display_navi($interval, $entire, $basehref, 'populary');
        }
        return $html;
    }
    
    function get_popular_links($pages, $linkstrs, $counts, $currentpage = '')
    {
        $links = array();
        foreach ($pages as $i => $page) {
            $linkstr = htmlspecialchars($linkstrs[$i]);
            $count   = $counts[$i];
            if ($count === 0) continue;
            if ($page == $currentpage) { // Do not link to itself
                $links[$i] = '<span title="' . htmlspecialchars($page) . ' ' . get_pg_passage($page, false) . '">' .
                    $linkstr . '<span class="counter">(' . $count . ')</span></span>';
            } else {
                $links[$i] = make_pagelink($page, $linkstr . '<span class="counter">(' . $count . ')</span>');
            }
        }
        return $links;
    }
}

///////////////////////////////////////////
function plugin_populary_init()
{
    global $plugin_populary_name;
    if (class_exists('PluginPopularyUnitTest')) {
        $plugin_populary_name = 'PluginPopularyUnitTest';
    } elseif (class_exists('PluginPopularyUser')) {
        $plugin_populary_name = 'PluginPopularyUser';
    } else {
        $plugin_populary_name = 'PluginPopulary';
    }
}
function plugin_populary_action()
{
    global $plugin_populary, $plugin_populary_name;
    $plugin_populary = new $plugin_populary_name();
    return call_user_func(array(&$plugin_populary, 'action'));
}
function plugin_populary_convert()
{
    global $plugin_populary, $plugin_populary_name;
    $plugin_populary = new $plugin_populary_name();
    $args = func_get_args();
    return call_user_func_array(array(&$plugin_populary, 'convert'), $args);
}

if (! defined('INIT_DIR')) // if not Plus! 
    if (file_exists(DATA_HOME . 'init/populary.ini.php')) 
        include_once(DATA_HOME . 'init/populary.ini.php');

?>
