<?php
require_once('sonots/sonots.class.php'); // sonots' func collection
require_once('sonots/option.class.php'); // option parser func collection
require_once('sonots/toc.class.php');    // section option requires toc
require_once('sonots/metapage.class.php'); // toc requires
//error_reporting(E_ALL);

/**
 * Page Include Plugin
 *
 * @package    plugin
 * @license    http://www.gnu.org/licenses/gpl.html GPL v2
 * @author     sonots
 * @link       http://lsx.sourceforge.jp/?Plugin%2Fincludey.inc.php
 * @version    $Id: includey.inc.php,v 2.0 2008-06-05 07:23:17Z sonots $
 * @require    sonots/sonots     v 1.9
 * @require    sonots/option     v 1.5
 * @require    sonots/toc        v 1.3
 * @require    sonots/metapage   v 1.4
 */
class PluginIncludey 
{
    function PluginIncludey()
    {
        // Configure options
        // array(type, default, config)
        static $conf_options = array(
             'num'       => array('interval', null),
             'except'    => array('string',   null),
             'filter'    => array('string',   null),
             'title'     => array('enum',     'on',  array('on', 'off', 'nolink', 'basename')), // obsolete
             'titlestr'  => array('enum',     'title', array('name', 'pagename', 'absolute',
                  'relname', 'relative', 'basename', 'title', 'headline', 'off',
             )),
             'titlelink' => array('bool',     true),
             'permalink' => array('string',   false),
             'firsthead' => array('bool',     true),
             'section'   => array('options',  null, array(
                 'num'       => array('interval', null),
                 'depth'     => array('interval', null),
                 'except'    => array('string'  , null),
                 'filter'    => array('string',   null),
                 'cache'     => array('bool',     true),
                 'inclsub'   => array('bool',     false), // not yet
             )),
        );
        // PukiWiki Syntax Definition
        static $syntax = array(
             'headline' => '/^(\*{1,3})/',
        );
        static $visited = array();
        $this->conf_options = &$conf_options;
        $this->syntax       = &$syntax;
        $this->visited      = &$visited;
    }
    
    // static
    var $conf_options;
    var $syntax;
    var $visited;
    var $plugin = "includey";
    
    /**
     * Convert Plugin Main Function
     */
    function convert()
    {
        sonots::init_myerror(); do { // try
            $args = func_get_args(); 
            
            $inclpage = array_shift($args);
            $inclpage = PluginIncludey::check_page($inclpage, $this->visited);
            if (sonots::mycatch()) break;
            
            $line = csv_implode(',', $args);
            $options = PluginSonotsOption::parse_option_line($line);
            list($options, $unknowns) = PluginSonotsOption::evaluate_options($options, $this->conf_options);
            $options = PluginIncludey::check_options($options, $unknowns);
            if (sonots::mycatch()) break;
            
            $this->visited[$inclpage] = TRUE;
            $html = PluginIncludey::display_include($inclpage, $options, $this->syntax);
            return $html;
        } while (false);
        if (sonots::mycatch()) { // catch
            return '</p>#includey(): ' . sonots::mycatch() . '</p>';
        }
    }
        
    /**
     * Include page
     *
     * @access tatic
     * @param string $page
     * @param array $options
     * @param array $syntax
     * @return string html
     */
    function display_include($page, $options, $syntax)
    {
        global $vars;
        $mb = extension_loaded('mbstring') ? 'mb_' : '';

        $lines = get_source($page);
        if (is_array($options['num'])) {
            list($offset, $length) = $options['num'];
            $lines = array_slice($lines, $offset, $length);
        }
        if (isset($options['filter'])) {
            $lines = sonots::grep_array($option['filter'], $lines, $mb . 'ereg');
        }
        if (isset($options['except'])) {
            $lines = sonots::grep_array($option['except'], $lines, $mb . 'ereg', TRUE); // inverse
        }
        if (! $options['firsthead']) {
            // cut the headline on the first line
            if (preg_match($syntax['headline'], $lines[0])) {
                unset($lines[0]);
            }
        }
        if (is_array($options['section'])) {
            $lines = PluginIncludey::get_sections($lines, $page, $options['section']);
        }

        // html
        $html = sonots::get_convert_html($page, $lines);

        $titlestr = PluginSonotsMetapage::linkstr($page, $options['titlestr'], $vars['page']);
        $title = PluginIncludey::display_title
            ($page, $titlestr, $options['title'], $GLOBALS['fixed_heading_edited'], 'includey');

        $footer = '';
        if ($options['permalink'] !== false) {
            $linkstr = sonots::make_inline($options['permalink']);
            $footer = '<p class="permalink">' . make_pagelink($page, $linkstr) . '</p>';
        }

        return $title . "\n" . $html . $footer;
    }


    /*
     * Get lines in the specified section only
     *
     * 0st sec
     * <h2>.....</h2> 1st head
     * 1st sec
     * <h2>.....</h2> 2nd head
     * 2nd sec
     *
     * @access static
     * @param array $lines
     * @param string $page
     * @param array $options section options
     * @return array lines
     * @uses PluginSonotsToc
     */
    function get_sections($lines, $page, $options)
    {
        $all = $toc = new PluginSonotsToc($page, $options['cache']);
        $mb = extension_loaded('mbstring') ? 'mb_' : '';

        if (isset($options['filter'])) {
            $toc->grep_by('string', $mb . 'ereg', $options['filter']);
        }
        if (isset($options['except'])) {
            $toc->grep_by('string', $mb . 'ereg', $options['except'], TRUE); // inverse
        }
        if (is_array($options['depth'])) {
            list($offset, $length) = $options['depth'];
            // Do not use negative offsets
            list($min, $max) = PluginSonotsOption::conv_interval($offset, $length, 1, PHP_INT_MAX);
            $toc->grep_by('depth', 'ge', $min);
            $toc->grep_by('depth', 'le', $max);
        }
        if (is_array($options['num'])) {
            list($offset, $length) = $options['num'];
            $toc->slice($offset, $length);
        }

        $end = key(end($lines));
        $headlinenums = $toc->get_metas('linenum');
        $allheadlinenums = $all->get_metas('linenum');
        $allheadlinenums[] = $end + 1; // virtual headline at the end
        $prev = -1; // virtual headline at the head
        $out = array();
        foreach ($allheadlinenums as $current) {
            if (in_array($current, $headlinenums)) {
                // cur prev headline + 1 to current headline - 1
                foreach (range($prev + 1, $current - 1) as $n) {
                    if (isset($lines[$n])) {
                        $out[$n] = $lines[$n];
                    }
                }
            }
            $prev = $current;
        }
        return $out;
    }

    /**
     * Check Option Compatibilities
     *
     * @access static
     * @param array $options
     * @param array $unknowns
     * @return array $options
     */     
    function check_options($options, $unknowns = array())
    {
        if ($options['title'] != 'on') {
            if ($options['title'] == 'nolink') {
                $options['titlelink'] = false;
                $options['titlestr'] = 'name';
            } else {
                $options['titlestr'] = $options['title'];
            }
        }
        if (is_null($options['permalink'])) {
            $options['permalink'] = _('Permalink');
        }
        return $options;
    }

    /**
     * Check Page Validity
     *
     * @access static
     * @param string $page
     * @param array $visited
     * @param string $page
     */
    function check_page($page, $visited = array())
    {
        global $vars;
        if (empty($page)) {
            sonots::mythrow("No page is specified."); return;
        }
        $current = $vars['page'];
        $page = get_fullname($page, $current);
        if (! is_page($page)) {
            sonots::mythrow('Page "' . htmlspecialchars($page) . '" does not exist.'); return;
        }
        if (! check_readable($page, false, false)) {
            sonots::mythrow('Page "' . htmlspecialchars($page) . '" is not readable.'); return;
        }
        if (isset($visited[$page])) {
            sonots::mythrow('Page "' . htmlspecialchars($page) . '" is already included.'); return;
        }
        return $page;
    }

    /**
     * Get <h1> title of a page
     * 
     * @access static
     * @param string $page pagename
     * @param string $titlestr titlestr
     * @param boolean $link link to page or not
     * @param boolean $editlink add edit link icon or not
     * @param string $cssclass
     * @return $string html
     */
    function display_title($page, $titlestr, $link = FALSE, $editlink = FALSE, $cssclass = '')
    {
        $aname = ' ' . sonots::make_pageanamelink_icon($page);
        $edit  = '';
        if ($titlestr == '') {
            return '<div class="' . $cssclass . '" style="padding:0px;margin:0px;">' . $aname . '</div>';
        }
        if ($editlink) {
            $edit = ' ' . sonots::make_pageeditlink_icon($page);
        }
        if ($link) {
            $titlestr = make_pagelink($page, $titlestr);
        }
        return '<h1 class="' . $cssclass . '">' . $titlestr . $edit . $aname . '</h1>';
    }
}

///////////////////////////////////////////
function plugin_includey_init()
{
    global $plugin_includey_name;
    if (class_exists('PluginIncludeyUnitTest')) {
        $plugin_includey_name = 'PluginIncludeyUnitTest';
    } elseif (class_exists('PluginIncludeyUser')) {
        $plugin_includey_name = 'PluginIncludeyUser';
    } else {
        $plugin_includey_name = 'PluginIncludey';
    }
}
function plugin_includey_convert()
{
    global $plugin_includey, $plugin_includey_name;
    $plugin_includey = new $plugin_includey_name();
    $args = func_get_args();
    return call_user_func_array(array(&$plugin_includey, 'convert'), $args);
}

if (! defined('INIT_DIR')) // if not Plus! 
    if (file_exists(DATA_HOME . 'init/includey.ini.php')) 
        include_once(DATA_HOME . 'init/includey.ini.php');

?>
