#
#    psutils.py
#
#    2004.2.22
#    2004.5.18
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
###########################################

class PSutils:
    def __init__(self):
        from  Lpy.lpy_programs import get_prg
        self.C_gs     = get_prg('gs')
        self.C_psselect = get_prg('psselect')
        self.C_psnup  = get_prg('psnup')
        self.C_psbook = get_prg('psbook')
        self.C_psset  = get_prg('psset')
        #C_pstops = get_prg('pstops')

    def set_nup_scale(self,nup):
        # source       target
        # -W -H -P ==> -w -h -p
        ## get source paper size ##
        psize = '-w%spt -h%spt' % (self.ww,self.hh)

        margin = self.parent.get_func(self.parent.T_marginleft).get_value()
        vmargin = 5 #10 # margin around virtual page
        if nup == 1:
            psize += " -b%d" % margin
        elif nup == 2: # landscape,A4
            scale = 0.62 # 0.64
            margin = margin/2
        elif nup == 4: # partrait,A4
            scale = 0.42 #0.45
            margin = 10 + margin/2
        elif nup == 3: # landscape,A4
            scale = 0.45
            margin = margin/4
        elif nup == 6: # partrait,A4
            scale = 0.31
            margin = margin/4
        elif nup == 8: # landscape,A4
            scale = 0.33
            margin = margin/4
        elif nup == 9: # partrait,A4
            scale = 0.31
            margin = margin/4

        if nup >= 2:
            psize += " -s%f -b%d -m%d" % (scale,margin,vmargin)
            # border :around each virtual page
            if self.parent.get_func(self.parent.T_border).get_value():
                psize += " -d1" # border-width == 1,2,3..
        return psize

    def set_duplex(self,duplex):
        if duplex in ("simple",'s') :
            val = '-s'
        elif duplex in ("duplex",'d'):
            val = '-d'
        elif duplex in ("tumble",'t'):
            val = '-t'
        elif duplex in ("manualfeed",'m'):
            val = '-m'
        if val:
           return " | %s -q -n %s -o-" % (self.C_psset,val)

    ## booklet
    def check_booklet(self):
        ## duplex and tray
        if self.parent.PJL.get_func(self.parent.PJL.P_duplex).get_support() != self.parent.ON:
            return 0
        ## PJL booklet
        if self.parent.PJL.get_func(self.parent.PJL.P_booklet).get_support() == self.parent.ON:
            return 0
        return self.parent.get_func(self.parent.T_booklet).get_value()

    def psutils(self):
        cmds = ''
        ## Page select
        if self.C_psselect and self.parent.get_func(self.parent.T_pageall).get_selected() == 1:
            pages = self.parent.get_func(self.parent.T_pagerange).get_value()
            if pages:
                cmd += " | %s -q -p%s" % (self.C_psselect,pages)
            """
                # 'reverse','even','odd'
                if option == 'reverse':
                    cmd += ' -r'
                elif option == 'even':
                    cmd += ' -e'
                elif option == 'odd':
                    cmd += ' -o'
            """
        ## Booklet
        booklet = self.check_booklet()
        if booklet >= 4 and self.C_psbook:
            cmds += ' | %s -q -s%d' % (self.C_psbook,booklet)

        ## Nup , PaperSize
        if self.C_psnup:
            xx,yy = self.parent.get_func(self.parent.T_nup).get_nup_value()
            nup = xx*yy
            cmds += " | %s -q -%d %s" % (self.C_psnup,nup,self.set_nup_scale(nup))
            orientation = self.parent.get_func(self.parent.T_portrait).get_nameValue()
            #if orientation == 'landscape':  # -90 clockwise
            #    cmds += " -l"
            #elif orientation == 'seascape': # 90 clockwise
            #    cmds += " -r"

        ## Duplex
        if booklet == 0 and self.C_psset:
            duplex = None
            if self.parent.PJL.get_func(self.parent.PJL.P_duplex).get_selected() == 1:
                duplex = "duplex"  # "tumble"

            if duplex: # simple,duplex,tumble,manualfeed
                cmd += self.set_duplex(duplex)
        return cmds
