#
#       output_data.py
#
#       2004.3.9
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import os

import Lpy.def_parm
import Lpy.def_printer
import Lpy.utils.file_utils
import Lpy.utils.get_env
import output_set
import file_type

class OutPut_Data(output_set.OutPut_Set):
    import file_convert
    to_ps = file_convert.TO_ps()
    multi_error = (_('Error: set filetype'),_('Error: convert to a PS file.'),_('Error:Output data'))
 
    def output_err(self,msg1,msg2):
        if not msg1:
            return None
        data = msg1
        if not msg1.endswith(os.linesep):
            data += os.linesep
        if msg2:
            msg = msg2
            if not msg2.endswith(os.linesep):
                msg += os.linesep
        else:
            msg = None

        self.write_logs(data,msg)

        if self.messages:
            if self.messages.get_pid() == 0:
                self.messages.start_Window(data,msg)
            else:
                self.messages.msg_logs(data,msg)

    def _set_filetype(self,continue_err):
        safe_count = 0
        files = self.get_func(self.T_outprinter).get_fileslist()
        for fcount in range(len(files)):
            filedata = files[fcount]
            ret = filedata.set_ftype()
            if ret:
                self.output_err(self.multi_error[0],ret)
                if continue_err == 0:
                    return 0
            else:
                safe_count += 1
            self.get_func(self.T_outprinter).set_filedata(fcount,filedata)
        return  safe_count

    ## convert to a psfile.
    def _convert_tops(self,filedata,multi_flag = 0):
        if multi_flag == 0:
            title = self.get_func(self.T_outprinter).get_ptitle()
            if title is None:
                title = filedata.title
            self.get_func(self.T_titletext).set_value(title)

            if self.current_print == None:
                self.current_print = title

        filedata.lang = file_type.F_ps
  
        if (self.to_ps.convertTypes.has_key(filedata.ftype) and
            self.to_ps.convertTypes[filedata.ftype][0] and
            self.to_ps.convertTypes[filedata.ftype][1]):

            filedata.psfile = self.to_ps.do_convert(filedata.ftype,self,filedata)
            if filedata.psfile is None:
                filedata.err_flag = _("I can't create a PSfile.")
                self.output_err(self.multi_error[1],filedata.err_flag)
        else:
            filedata.err_flag = _("I can't have a program to convert a file (%s).") % filedata.get_filename()
            self.output_err(self.multi_error[1],filedata.err_flag)
        return filedata.err_flag

    ## Transfer to Printer
    def _separate_output(self,continue_err):
        files = self.get_func(self.T_outprinter).get_fileslist()
        for filedata in files:
            if filedata.err_flag:
                if not continue_err:
                    break
            msg = self._convert_tops(filedata,0)
            if msg and continue_err == 0:
                    return msg

            title = self.get_func(self.T_outprinter).get_ptitle()
            if title is None:
                title = self.get_func(self.T_titletext).get_value()
            msg = self.out_data_cmds(None,filedata.lang,filedata.get_output_file(),filedata.no_convert,title)
            if msg:
                self.output_err(self.multi_error[2],msg)
                if continue_err == 0:
                    return msg
        return None

    ## Transfer multi-files to Printer
    def _set_multi_files(self,filedata,outflag):
        title = self.get_func(self.T_outprinter).get_ptitle()
        if title:
            self.get_func(self.T_titletext).set_value(title)
            filedata.title = title
            self.current_print = title

        filedata.ftype = file_type.F_text
        filedata.filename = ''
        filedata.orgfile  = ''

        files = self.get_func(self.T_outprinter).get_fileslist()
        for fdata in files:

            if filedata.title is None:
                filedata.title = fdata.title
            # filetype == TEXT only
            #if outflag:
            if fdata.ftype != file_type.F_text:
                return _("Multifiles(%s) are not transformed into a PSfile.(Text files Only supported)") % (fdata.ftype)
            #else: 
            #    return _("I can't transform a PDL(%s) into a PSfile.") % (fdata.ftype)

            filedata.filename += fdata.filename + ' '
            if fdata.orgfile:
                filedata.orgfile += fdata.orgfile  + ' '
            else:
                filedata.orgfile += fdata.filename + ' '

        msg = self._convert_tops(filedata,1)
        if msg:
            filedata.clean_tmpfile()
            return msg
        if outflag: # output PSfile
            return None
        msg = self.out_data_cmds(None,file_type.F_ps,filedata.psfile,None,filedata.title)
        if msg:
            self.output_err(self.multi_error[2],msg)
        filedata.clean_tmpfile()
        return msg

    ## transform PS_File
    def _output_to_file(self,vcount):
        if vcount == 1:
            filedata = self.get_func(self.T_outprinter).get_fileslist()[0]
            msg = self._convert_tops(filedata,0)
        elif vcount > 1:
            filedata = file_type.FileAttrib('multi_tmp',file_type.F_text)
         
            def_align = self.get_func(self.T_filealign).get_value()
            if def_align >= Lpy.def_printer.File_align.new_sheet:
                self.get_func(self.T_filealign).set_value(Lpy.def_printer.File_align.new_page)
            msg = self._set_multi_files(filedata,1)
            if def_align >= Lpy.def_printer.File_align.new_sheet:
                self.get_func(self.T_filealign).set_value(Lpy.def_printer.File_align.new_sheet)

        if filedata.psfile and msg is None:
            filename = self.get_func(self.T_outfile).get_value()
            ret = Lpy.utils.file_utils.rename_file(filedata.psfile,filename)
            if ret is None: # error
                msg =  _("Outout File:rename Error.")
            filedata.clean_tmpfile()
        return msg

    def output_data(self):
        outflag = self.get_func(self.T_output).get_value()
        if outflag == self.off and self.printer == Lpy.def_parm.Dummy:
            message = _("A Output Printer is not defined.")
            data    = _('First, Setup your printer.')
            self.error_menu(message,data)
            return 1

    ## sure
        if self.menutype == self.Display_menu:
            if outflag == self.off:
                target =  _('Printer') + os.linesep + '(%s)' % self.printer
            else:
                target = _('File') + os.linesep + '(%s)' % self.get_func(self.T_outfile).get_value()
            if self.sure_dialog(_("Output") + ' ' + target,_('Start Printout')) is None:
               return None

        self.current_print = None

    ## Mesage Test
        #if self.messages:
        #    self.output_err('Test','Messages test2')
  
        continue_err = self.get_func(self.T_errorstop).get_value()
        safe_count = self._set_filetype(continue_err)
        vcount = self.get_func(self.T_outprinter).get_vcount()

        ## to PS_File
        if outflag == self.ok:
            if safe_count == vcount:
                err_msg = self._output_to_file(vcount)
            else:
                err_msg = _('NO supported filetype is selected.')
   
        ## to Printer
        else:
            if vcount == 1:
                if safe_count == vcount:
                    err_msg = self._separate_output(Lpy.def_printer.Error_stop.stop_err)
            elif vcount > 1:
                nup = self.get_func(self.T_nup).get_value()
                def_align = self.get_func(self.T_filealign).get_value()

                if nup >=1 and def_align < Lpy.def_printer.File_align.new_sheet:
                    if safe_count == vcount:
                        #err_msg = self._set_multi_files(0)
                        filedata = file_type.FileAttrib('multi_tmp',file_type.F_text)
                        err_msg  = self._set_multi_files(filedata,0)
                    else:
                        err_msg  = _('NO supported filetype is selected.')
                else:
                    if safe_count == vcount or continue_err:
                        err_msg = self._separate_output(continue_err)

        ## save parameter
        if err_msg:
            if self.messages and self.messages.get_pid():
                self.output_err(self.multi_error[2],err_msg)
            else:
                self.error_menu(self.multi_error[2],err_msg)
        else:
            msg = _("OK:Data was transfered (%s)") % self.current_print
            self.save_a2ps_file(self.lastprinter)
            self.write_logs(msg,None)
            if self.messages and self.messages.get_pid():
                self.messages.msg_logs(msg)

        self.get_func(self.T_outprinter).clean_tmpfile()
        return None

