# loopy test -
# Aug.23.2011
# koji.ota

set trace 0

puts "loopy test"

source loopy.tcl

puts "version $loopy::_config_(version)"

puts "TEST: object test"
set obj [loopy::class new Object]
if {$trace} { $obj dump }
puts -nonewline "creation .................. "
if {$obj != {}} {
    puts "pass."
} else {
    puts "failed."
}

puts -nonewline "deletion .................. "
loopy::delete $obj
catch {$obj dump} result
if {$result != {}} {
	#puts "!!eror occur!!"
	#puts "$result"
	puts "pass."
} else {
	puts "failed."
}

puts -nonewline "method1  .................. "
set obj [loopy::class new Object]
proc sayHello { this } { return "Hello." }
$obj method sayHello sayHello
if {$trace} { $obj dump }
set text [$obj sayHello]
if ![string compare "Hello." $text] {
    puts "pass."
} else {
    puts "failed."
}
puts -nonewline "method2  .................. "
proc sayHello2 { this } { return "Hello, world." }
$obj method sayHello sayHello2
if {$trace} { $obj dump }
set text [$obj sayHello]
if ![string compare "Hello, world." $text] {
    puts "pass."
} else {
    puts "failed."
}

loopy::delete $obj

#
puts "class definition test."
proc Vector2d.dumpCmd { this } {
	puts -nonewline "([$this get x],[$this get y])"
}
proc Vector2d.setDataCmd { this x y } {
	$this set x $x
	$this set y $y
}
proc Vector2d.getDataCmd { this } {
	return "[$this get x] [$this get y]"
}
loopy::class register Vector2d {
	inherits {
	}
	variables {
		x	0
		y	0
	}
	methods {
		dump		Vector2d.dumpCmd
		setData		Vector2d.setDataCmd
		getData		Vector2d.getDataCmd
	}
}
set obj [loopy::class new Vector2d]
$obj setData 1 2
if {$trace} { $obj dump ; puts ""}
puts -nonewline "Vector2d .................. "
if ![string compare "1 2" [$obj getData]] {
    puts "pass."
} else {
    puts "failed."
}
loopy::delete $obj

# 
proc Vector3d.dumpCmd { this } {
	puts -nonewline "([$this get x],[$this get y],[$this get z])"
}
proc Vector3d.setDataCmd { this x y z } {
	$this set x $x
	$this set y $y
	$this set z $z
}
proc Vector3d.getDataCmd { this } {
	return "[$this get x] [$this get y] [$this get z]"
}
loopy::class register Vector3d {
	inherits {
		Vector2d
	}
	variables {
		z	0
	}
	methods {
		dump		Vector3d.dumpCmd
		setData		Vector3d.setDataCmd
		getData		Vector3d.getDataCmd
	}
}
set obj [loopy::class new Vector3d]
$obj setData 1 2 3
if {$trace} { $obj dump ; puts ""}
puts -nonewline "Vector3d .................. "
if ![string compare "1 2 3" [$obj getData]] {
    puts "pass."
} else {
    puts "failed."
}
loopy::delete $obj

#
loopy::class register A {
	inherits {
	}
	variables {
		var		10
	}
	methods {
	}
}
loopy::class register B {
	inherits {
		A
	}
	variables {
		var		20
	}
	methods {
	}
}
set obj [loopy::class new B]
puts -nonewline "Inheritance 1 ............. "
if {[$obj get var] == 20} {
    puts "pass."
} else {
    puts "failed."
}
puts -nonewline "Inheritance 2 ............. "
if ![string compare B [$obj instanceof]] {
    puts "pass. ([$obj instanceof])"
} else {
    puts "failed."
}
puts -nonewline "Inheritance 3 ............. "
if [$obj instanceof B] {
    puts "pass. (B is [$obj instanceof B])"
} else {
    puts "failed."
}
puts -nonewline "Inheritance 4 ............. "
if [$obj instanceof A] {
    puts "pass. (A is [$obj instanceof A])"
} else {
    puts "failed."
}
puts -nonewline "Inheritance 5 ............. "
if ![$obj instanceof Vector3d] {
    puts "pass. (Vector3d is [$obj instanceof Vector3d])"
} else {
    puts "failed."
}
loopy::delete $obj

#
set obj [loopy::class new Object]
set className [$obj instanceof]
puts -nonewline "instanceof test ........... "
if ![string compare "Object" $className] {
    puts "pass. <$className>"
} else {
    puts "failed."
}
$obj set z 12345
puts -nonewline "scope test ................ "
puts "[$obj scope z]=[subst \"$[$obj scope z]\"]"
$obj hook set checkFunc
proc checkFunc { this name value } {
	puts "$name of $this was changed to $value."
}
$obj set z abcde

#package require Tk
#pack [entry .a -textvariable [$obj scope z]]
#bind .a <Return> "puts \"z=\[$obj get z\]\""

#
puts "v4 feature test."

