# loopy -
# Aug.23.2011
# koji.ota
# Copyright(C) 2011 Koji Ota All Rights Reserved.

package provide loopy 0.4

namespace eval loopy {
	
	variable _config_
	variable _gvar_
	variable _object_
	variable _class_
	
	array set _config_ {
		version		"0.4.r.1"
	}
	
	array set _gvar_ {
		uid			1
	}
	
	proc gvar { name args } {
		variable _gvar_
		if {[llength $args] != 0} {
			set _gvar_($name) [lindex $args 0]
		}
		return $_gvar_($name)
	}
	
	proc unique { } {
		variable _gvar_
		set uid $_gvar_(uid)
		incr _gvar_(uid)
		return $uid
	}
	
	proc setCmdWithHook { obj name value } {
		variable _object_
		set this $obj
		set obj [namespace tail $obj]
		set _object_($obj,var,$name) $value
		if [info exists _object_($obj,hook,set)] {
			eval "$_object_($obj,hook,set) $this $name $value"
		}
	}
	
	proc setCmd { obj name value } {
		variable _object_
		set obj [namespace tail $obj]
		set _object_($obj,var,$name) $value
	}
	
	proc getCmd { obj name } {
		variable _object_
		set obj [namespace tail $obj]
		return $_object_($obj,var,$name)
	}
	
	proc methodCmd { obj method {body {}}} {
		variable _object_
		set obj [namespace tail $obj]
		if {$body != {}} {
			set _object_($obj,method,$method) $body
		}
		if [info exists _object_($obj,method,$method)] {
			return $_object_($obj,method,$method)
		} else {
			return {}
		}
	}
	
	proc dumpCmd { obj } {
		variable _object_
		set obj [namespace tail $obj]
		puts "$obj has:"
		foreach prop [array names _object_ "$obj,*"] {
			puts "($prop = $_object_($prop))"
		}
	}
	
	proc instanceofCmd { obj {c {}} } {
		variable _object_
		if {$c == {}} {
			# returns class
			set obj [namespace tail $obj]
			return $_object_($obj,class)
		} else {
			# checks whether the class is contained in object.
			set obj [namespace tail $obj]
			set p [lsearch $_object_($obj,inheritance) $c]
			if {$p >= 0} {
				return 1
			} else {
				return 0
			}
		}
	}
	
	proc scopeCmd { obj name } {
		variable _object_
		set obj [namespace tail $obj]
		return loopy::_object_($obj,var,$name)
	}
	
	# hooker is special. it is defined by loopy. user cannot create hook name freely.
	# it is defined as follows:
	# 'invoke', 'set'(set should be inherited.)
	proc setHookCmd { obj hooker {body {}}} {
		variable _object_
		set obj [namespace tail $obj]
		if {$body != {}} {
			set _object_($obj,hook,$hooker) $body
		}
		if [info exists _object_($obj,hook,$hooker)] {
			return $_object_($obj,hook,$hooker)
		} else {
			return {}
		}
	}
	
	proc invokeCmd { name subcmd args } {
		variable _object_
		
		if {$_object_($name,method,$subcmd) != {}} {
			eval "$_object_($name,method,$subcmd) loopy::$name $args"
		}
	}
	
	proc inheritCmd { obj superClasses } {
	}
	
	proc inherit { obj super } {
		variable _class_
		variable _object_
		lappend _object_($obj,inheritance) $super
		foreach { pname pvalue } $_class_($super,body) {
			switch $pname {
				inherits {
					foreach psuper $pvalue {
						inherit $obj $psuper
					}
				}
				variables {
					foreach { qname qbody } $pvalue {
						set _object_($obj,var,$qname) $qbody
					}
				}
				methods {
					foreach { qname qbody } $pvalue {
						set _object_($obj,method,$qname) $qbody
					}
				}
			}
		}
	}
	
	proc class {subcmd name args } {
		variable _class_
		variable _object_
		switch $subcmd {
			register {
				set _class_($name,body) [lindex $args 0]
			}
			new {
				set obj "loopy[unique]"
				set _object_($obj,class) $name
				set _object_($obj,inheritance) {}
				set _object_($obj,method,init) {}
				set _object_($obj,method,destructor) {}
				set _object_($obj,method,set) setCmd
				set _object_($obj,method,get) getCmd
				set _object_($obj,method,dump) dumpCmd
				set _object_($obj,method,method) methodCmd
				# v0.3
				set _object_($obj,method,scope) scopeCmd
				set _object_($obj,method,hook) setHookCmd
				# v0.4
				set _object_($obj,method,instanceof) instanceofCmd
				# v0.5
				set _object_($obj,method,inherit) inheritCmd
				
				inherit $obj $name
				proc $obj { subcmd args } "eval \"loopy::invokeCmd $obj \$subcmd \$args\""
				$obj init
				
				return loopy::$obj
			}
		}
	}
	class register Object {}
	
	proc delete { args } {
		variable _object_
		foreach obj $args {
			$obj destructor
			array unset _object_ "$obj,*"
			rename $obj ""
		}
	}
}

