/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2011 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GtkWSCstring.h,v 1.9 2011/01/09 01:59:31 bowkenken Exp $
***************************************************************/

#ifndef GTK_WSC_STRING_H
#define GTK_WSC_STRING_H	1

#include <string>

using namespace std;

enum {
	WS_EN_DEFAULT = 0,
};

class WSCstring : public string
{
public:
	WSCstring();
	WSCstring( char *str );
	WSCstring( const char *str );
	WSCstring( string str );
	WSCstring( long n );

	operator char *();
	WSCstring operator +( WSCstring str );
	WSCstring operator +( char *str );
	WSCstring &operator <<( WSCstring str );
	char operator []( int n );

	long getChars();
	void deleteChar( long pos );
	void deleteChars( long pos, long len );

	long getWords(
		WSCstring str = " ", long encoding = WS_EN_DEFAULT );
	long getWordCharPos(
		long n, WSCstring str, long encoding = WS_EN_DEFAULT );
	void cutString( long pos, long encoding = WS_EN_DEFAULT );
	WSCstring getWord(
		long n, WSCstring str, long encoding = WS_EN_DEFAULT );
};

#endif // GTK_WSC_STRING_H
