/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2010 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: amenu-tab.h,v 1.23 2010/06/24 04:10:24 bowkenken Exp $
***************************************************************/

#ifndef	AMENU_TAB_H
#define	AMENU_TAB_H

/* ưޡ˥塼 */

static menu_t	ls_menu_auto_mark
		[1 + (14 * AUTO_MARK_MAX_N)
		+ (3 * AUTO_MARK_PAGE_N) + 2];

static menu_t	ls_menu_appoint_item
		[1 + 1 + (AUTO_MARK_APPOINT_ITEM_MAX_N * 2) + 1];

static menu_t	ls_menu_auto_mark_edit[] = {
	{
		"/edit",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_edit_init,
		NULL,
		FLG_NULL,
	},
	{
		"/edit/title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL,
		NULL,
		FLG_NULL,
	},
/* Position */
	{
		"/edit/position",
		"<Item>",
		'F',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_position,
		NULL,
		FLG_NULL,
	},
/* Target */
	{
		"/edit/target",
		"<Branch>",
		'T',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_trgt_init,
		NULL,
		FLG_NULL,
	},
	{
		"/edit/target/title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL,
		NULL,
		FLG_NULL,
	},
	{
		"/edit/target/monster",
		"<Item>",
		'X',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_MNSTR, "",
		cb_menu_auto_mark_trgt,
		(void *)AUTO_MARK_TRGT_MNSTR,
		FLG_NULL,
	},
	{
		"/edit/target/item",
		"<Item>",
		'I',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_ITEM, "",
		cb_menu_auto_mark_trgt,
		(void *)AUTO_MARK_TRGT_ITEM,
		FLG_NULL,
	},
	{
		"/edit/target/door",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_DOOR, "",
		cb_menu_auto_mark_trgt,
		(void *)AUTO_MARK_TRGT_DOOR,
		FLG_NULL,
	},
	{
		"/edit/target/trap",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_TRAP, "",
		cb_menu_auto_mark_trgt,
		(void *)AUTO_MARK_TRGT_TRAP,
		FLG_NULL,
	},
	{
		"/edit/target/member",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_MBR, "",
		cb_menu_auto_mark_trgt,
		(void *)AUTO_MARK_TRGT_MBR,
		FLG_NULL,
	},
	{
		"/edit/target/unchange",
		"<Item>",
		'U',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_UNCHANGE, "",
		cb_menu_auto_mark_trgt,
		(void *)AUTO_MARK_TRGT_UNCHANGE,
		FLG_NULL,
	},
	{
		"/edit/target/clear",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_CLEAR, "",
		cb_menu_auto_mark_trgt,
		(void *)AUTO_MARK_TRGT_CLEAR,
		FLG_NULL,
	},
/* Dist */
	{
		"/edit/dist",
		"<Branch>",
		'D',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_dist_init,
		NULL,
		FLG_NULL,
	},
	{
		"/edit/dist/title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL,
		NULL,
		FLG_NULL,
	},
	{
		"/edit/dist/near",
		"<Item>",
		'N',
		"",
		N_MSG_MENU_AUTO_MARK_DIST_NEAR, "",
		cb_menu_auto_mark_dist,
		(void *)AUTO_MARK_DIST_NEAR,
		FLG_NULL,
	},
	{
		"/edit/dist/medium",
		"<Item>",
		'M',
		"",
		N_MSG_MENU_AUTO_MARK_DIST_MEDIUM, "",
		cb_menu_auto_mark_dist,
		(void *)AUTO_MARK_DIST_MEDIUM,
		FLG_NULL,
	},
	{
		"/edit/dist/far",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_AUTO_MARK_DIST_FAR, "",
		cb_menu_auto_mark_dist,
		(void *)AUTO_MARK_DIST_FAR,
		FLG_NULL,
	},
/* Action */
	{
		"/edit/action",
		"<Branch>",
		'A',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_act_init,
		NULL,
		FLG_NULL,
	},
	{
		"/edit/action/title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL,
		NULL,
		FLG_NULL,
	},
	{
		"/edit/action/fight",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_FIGHT, "",
		cb_menu_auto_mark_act,
		(void *)AUTO_MARK_ACT_FIGHT,
		FLG_NULL,
	},
	{
		"/edit/action/throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_THROW, "",
		cb_menu_auto_mark_act,
		(void *)AUTO_MARK_ACT_THROW,
		FLG_NULL,
	},
	{
		"/edit/action/steal",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_STEAL, "",
		cb_menu_auto_mark_act,
		(void *)AUTO_MARK_ACT_STEAL,
		FLG_NULL,
	},
	{
		"/edit/action/tail",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_TAIL, "",
		cb_menu_auto_mark_act,
		(void *)AUTO_MARK_ACT_TAIL,
		FLG_NULL,
	},
	{
		"/edit/action/pick up",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_PICK_UP, "",
		cb_menu_auto_mark_act,
		(void *)AUTO_MARK_ACT_PICK_UP,
		FLG_NULL,
	},
	{
		"/edit/action/open",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_OPEN, "",
		cb_menu_auto_mark_act,
		(void *)AUTO_MARK_ACT_OPEN,
		FLG_NULL,
	},
	{
		"/edit/action/close",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_CLOSE, "",
		cb_menu_auto_mark_act,
		(void *)AUTO_MARK_ACT_CLOSE,
		FLG_NULL,
	},
	{
		"/edit/action/jam",
		"<Item>",
		'J',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_JAM, "",
		cb_menu_auto_mark_act,
		(void *)AUTO_MARK_ACT_JAM,
		FLG_NULL,
	},
	{
		"/edit/action/disarm",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_DISARM, "",
		cb_menu_auto_mark_act,
		(void *)AUTO_MARK_ACT_DISARM,
		FLG_NULL,
	},
	{
		"/edit/action/break",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_BREAK, "",
		cb_menu_auto_mark_act,
		(void *)AUTO_MARK_ACT_BREAK,
		FLG_NULL,
	},
	{
		"/edit/action/peep",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_PEEP, "",
		cb_menu_auto_mark_act,
		(void *)AUTO_MARK_ACT_PEEP,
		FLG_NULL,
	},
	{
		"/edit/action/search",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_CHK, "",
		cb_menu_auto_mark_act,
		(void *)AUTO_MARK_ACT_CHK,
		FLG_NULL,
	},
/* Condition */
	{
		"/edit/condition",
		"<Branch>",
		'C',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_cond_init,
		NULL,
		FLG_NULL,
	},
	{
		"/edit/condition/title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL,
		NULL,
		FLG_NULL,
	},
	{
		"/edit/condition/nearest",
		"<Item>",
		'N',
		"",
		N_MSG_MENU_AUTO_MARK_COND_NEAREST, "",
		cb_menu_auto_mark_cond,
		(void *)AUTO_MARK_COND_NEAREST,
		FLG_NULL,
	},
	{
		"/edit/condition/disperse",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_AUTO_MARK_COND_DISPERSE, "",
		cb_menu_auto_mark_cond,
		(void *)AUTO_MARK_COND_DISPERSE,
		FLG_NULL,
	},
	{
		"/edit/condition/stagger",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_AUTO_MARK_COND_STAGGER, "",
		cb_menu_auto_mark_cond,
		(void *)AUTO_MARK_COND_STAGGER,
		FLG_NULL,
	},
	{
		"/edit/condition/own",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_AUTO_MARK_COND_OWN, "",
		cb_menu_auto_mark_cond,
		(void *)AUTO_MARK_COND_OWN,
		FLG_NULL,
	},
	{
		"/edit/condition/identified",
		"<Item>",
		'I',
		"",
		N_MSG_MENU_AUTO_MARK_COND_IDENTIFIED, "",
		cb_menu_auto_mark_cond,
		(void *)AUTO_MARK_COND_IDENTIFIED,
		FLG_NULL,
	},
	{
		"/edit/condition/unidentified",
		"<Item>",
		'U',
		"",
		N_MSG_MENU_AUTO_MARK_COND_UN_IDENTIFIED, "",
		cb_menu_auto_mark_cond,
		(void *)AUTO_MARK_COND_UN_IDENTIFIED,
		FLG_NULL,
	},
	{
		"/edit/condition/hp min",
		"<Item>",
		'W',
		"",
		N_MSG_MENU_AUTO_MARK_COND_HP_MIN, "",
		cb_menu_auto_mark_cond,
		(void *)AUTO_MARK_COND_HP_MIN,
		FLG_NULL,
	},
	{
		"/edit/condition/hp max",
		"<Item>",
		'X',
		"",
		N_MSG_MENU_AUTO_MARK_COND_HP_MAX, "",
		cb_menu_auto_mark_cond,
		(void *)AUTO_MARK_COND_HP_MAX,
		FLG_NULL,
	},
	{
		"/edit/condition/mp min",
		"<Item>",
		'Y',
		"",
		N_MSG_MENU_AUTO_MARK_COND_MP_MIN, "",
		cb_menu_auto_mark_cond,
		(void *)AUTO_MARK_COND_MP_MIN,
		FLG_NULL,
	},
	{
		"/edit/condition/mp max",
		"<Item>",
		'Z',
		"",
		N_MSG_MENU_AUTO_MARK_COND_MP_MAX, "",
		cb_menu_auto_mark_cond,
		(void *)AUTO_MARK_COND_MP_MAX,
		FLG_NULL,
	},
/* Appoint Item */
	{
		"/edit/appoint item",
		"<Branch>",
		'I',
		"",
		N_MSG_MENU_AUTO_MARK_EDIT_APPOINT_ITEM, "",
		cb_menu_auto_mark_appoint_item,
		NULL,
		FLG_NULL,
	},
/* Macro */
	{
		"/edit/macro",
		"<Branch>",
		'M',
		"",
		N_MSG_MENU_AUTO_MARK_EDIT_MACRO, "",
		NULL,
		NULL,
		FLG_NULL,
	},
	{
		"/edit/macro/bind",
		"<OpenWinItem>",
		'B',
		"",
		N_MSG_MENU_AUTO_MARK_EDIT_MACRO_BIND, "",
		cb_menu_auto_mark_edit_macro_bind,
		NULL,
		FLG_NULL,
	},
	{
		"/edit/macro/reg",
		"<OpenWinItem>",
		'M',
		"",
		N_MSG_MENU_AUTO_MARK_EDIT_MACRO_REG_MACRO, "",
		cb_menu_auto_mark_edit_macro_reg_macro,
		NULL,
		FLG_NULL,
	},
/**/
	{
		"/edit/continue",
		"<CheckItem>",
		'O',
		"",
		N_MSG_MENU_AUTO_MARK_EDIT_CONT, "",
		cb_menu_auto_mark_cont,
		NULL,
		FLG_NULL,
	},
	{
		"/edit/priority",
		"<CheckItem>",
		'P',
		"",
		N_MSG_MENU_AUTO_MARK_EDIT_PRIORITY, "",
		cb_menu_auto_mark_priority,
		NULL,
		FLG_NULL,
	},
	{
		"/edit/copy",
		"<Item>",
		'W',
		"",
		N_MSG_MENU_AUTO_MARK_COPY_S, "",
		cb_menu_auto_mark_copy_small,
		NULL,
		FLG_NULL,
	},
	{
		"/edit/paste",
		"<Item>",
		'Y',
		"",
		N_MSG_MENU_AUTO_MARK_PASTE_S, "",
		cb_menu_auto_mark_paste_small,
		NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL,
		NULL,
		FLG_NULL,
	},
};

#endif	/* AMENU_TAB_H */
