/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2010 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: DemoGameOver.h,v 1.4 2010/07/08 18:16:24 bowkenken Exp $
***************************************************************/

#ifndef DEMO_GAME_OVER_H
#define DEMO_GAME_OVER_H	1

////////////////////////////////////////////////////////////////
// ࡦСǥ
////////////////////////////////////////////////////////////////

#ifdef D_GTK
# include <gtk/gtk.h>
#endif /* D_GTK */

#ifdef D_MFC
# include "xlnl-dows/stdafx.h"
# include "xlnl-dows/xlnl-dows.h"
# include "xlnl-dows/Dir3dText.h"
#endif // D_MFC

#include "Pcg.h"

////////////////////////////////////////////////////////////////

class DemoGameOver {
public:

private:
	// Ф줿ࡦСΥեֹ
	long nGameOverRandmSelN;
	// ࡦСΥե
	long nGameOverN;
	// ࡦСβ
	Pcg pcgGameOver;

	long frame;
	time_t wait_time;

	// ˥Ѻɸ
	long len;
	long w, h;
	long baseX, baseY;
	long mx[3][16], my[3][16];
	long x[3][16], y[3][16];

#ifdef D_GTK
	// եȤΥ
	GtkStyle *pGameOverStyle;
#endif // D_GTK
	
#ifdef D_IPHONE
	// եȤΥ
//@@@
	void *pGameOverStyle;
#endif // D_IPHONE
	
#ifdef D_MFC
	// եȤΥ
	void *pGameOverStyle;
	LOGFONT mGameOverFontDesc;
	CFont *pGameOverFont;

	CDir3dText mD3GameOver;
#endif // D_MFC

public:
	DemoGameOver();
	~DemoGameOver();
	void init();

	bool draw();

private:
	void initAnime();

	bool drawWait();
	bool drawEnd();

	void drawGameOver( long frame );
	void drawGameOverString();
	void drawGameOverCharStd( long x, long y, char c );
	void drawGameOverChar(
		long r, long g, long b,
		long x, long y, char c );
};

#endif // DEMO_GAME_OVER_H
