/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2009 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GameSound.h,v 1.3 2009/01/04 00:26:03 bowkenken Exp $
***************************************************************/

#ifndef GAME_SOUND_H
#define GAME_SOUND_H	1

////////////////////////////////////////////////////////////////
// SE δ
////////////////////////////////////////////////////////////////

#ifdef	HAVE_SDL_SDL_H
# include <SDL/SDL.h>
#endif
#ifdef	HAVE_SDL_SDL_MIXER_H
# include <SDL/SDL_mixer.h>
#endif

#include "sound-kind.h"

////////////////////////////////////////////////////////////////

// SE ǡǥ쥯ȥ
#define STR_DEFAULT_SOUND_DIR_NAME	"xlnl-" VERSION "/"
// SE Υե̾γĥ
#define	STR_SOUND_FILE_EXT	"ogg mp3 wav"

// SE Υե̾ꥹ
struct LsSound {
	//  SE
	LsSound *next;

	// SE Υե̾
	WSCstring name;

	// SE Υǡ
	Mix_Chunk *chunk;
};

////////////////////////////////////////////////////////////////

class GameSound {
public:
private:
	LsSound lsDoorOpen;
	LsSound lsDoorClose;

	LsSound lsShopPay;
	LsSound lsShopDrink;

	LsSound lsHitMbr;
	LsSound lsHitMnstr;
	LsSound lsCrtclMbr;
	LsSound lsCrtclMnstr;

public:
	GameSound();
	~GameSound();
	void init();
	void close();

	void play( sound_kind_t kind, long nRepeat );

private:
	void initLsSound( LsSound *ls, WSCstring dir );

	void freeAll();
	void freeLsSound( LsSound *ls );

	void playRandm( LsSound *p, long nRepeat );
};

#endif /* GAME_SOUND_H */
