/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: turn.c,v 1.38 2007/01/11 17:31:35 bowkenken Exp $
***************************************************************/

/***************************************************************
* 
***************************************************************/

#define	TURN_C
#include	"inc.h"

/***************************************************************
* ѿ
***************************************************************/

static long	g_day, g_turn;

/***************************************************************
* ν
* return : 
***************************************************************/

long	init_turn()
{
	set_game_date( 999, 4, 1 );
	reset_turn( 10 * TURN_PER_HOUR );

	return g_turn;
}

/***************************************************************
* ꤷƥꥻå
* long n : ꤹ륿
* return : 
***************************************************************/

long	reset_turn( long n )
{
	g_turn = n;

	if( g_turn >= 0 )
		g_day += g_turn / TURN_A_DAY;
	else
		g_day -= labs( g_turn ) / TURN_A_DAY + 1;

	g_turn %= TURN_A_DAY;
	g_turn += TURN_A_DAY;
	g_turn %= TURN_A_DAY;

	return g_turn;
}

/***************************************************************
* ʤ
* long n : ʤ륿
* return : 
***************************************************************/

long	add_turn( long n )
{
	long	ret;
	long	i;

	ret = -1;

	for( i = 0; i < n; i++ )
		ret = inc_turn();

	return ret;
}

/***************************************************************
*  1 Ŀʤ
* return : 
***************************************************************/

long	inc_turn( void )
{
	g_turn++;
	draw_misc_stat_time( FALSE );
	reset_day();

	chk_morning_glow( g_turn );
	chk_evening_glow( g_turn );
	chk_discount_day();
	chk_discount_queue();

	inc_turn_all_item();
	inc_turn_all_fx();
	inc_turn_all_mnstr();

	return g_turn;
}

/***************************************************************
* 
* long n : ꤹ륿
* return : 
***************************************************************/

long	set_turn( long n )
{
	return reset_turn( n );
}

/***************************************************************
* ֤
* return : 
***************************************************************/

long	get_turn( void )
{
	return g_turn;
}

/***************************************************************
* դꤷƥꥻå
* return : 
***************************************************************/

long	reset_day( void )
{
	for( ; g_turn >= TURN_A_DAY; g_turn -= TURN_A_DAY )
		inc_day();

	return g_day;
}

/***************************************************************
* դ 1 ʤ
* return : 
***************************************************************/

long	inc_day( void )
{
	g_day++;

	inc_day_all_fx();

	chk_request_limit();
	chk_request_npc_contract();

	return g_day;
}

/***************************************************************
* ǯդ
* long year : ǯ
* long month : 
* long day : 
* return : 
***************************************************************/

long	set_game_date( long year, long month, long day )
{
	g_day = 0;
	g_day += year * 360;
	g_day += (month - 1) * 30;
	g_day += day - 1;

	return g_day;
}

/***************************************************************
* դ
* long day : 
* return : 
***************************************************************/

long	set_game_day( long day )
{
	g_day = day;

	return g_day;
}

/***************************************************************
* դ֤
* return : 
***************************************************************/

long	get_game_day( void )
{
	return g_day;
}

/***************************************************************
* ߤΥνФĴ٤
* return : νФ?
***************************************************************/

bool_t	chk_morning( void )
{
	long	turn;

	turn = get_turn() % TURN_A_DAY;

	if( turn < (MORNING_HOUR * TURN_PER_HOUR) )
		return FALSE;
	if( turn >= ((MORNING_HOUR + 1) * TURN_PER_HOUR) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ߤΥ꤫Ĵ٤
* return : ꤫?
***************************************************************/

bool_t	chk_evening( void )
{
	long	turn;

	turn = get_turn() % TURN_A_DAY;

	if( turn < (EVENING_HOUR * TURN_PER_HOUR) )
		return FALSE;
	if( turn >= ((EVENING_HOUR + 1) * TURN_PER_HOUR) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ߤΥ뤫Ĵ٤
* return : 뤫?
***************************************************************/

bool_t	chk_night( void )
{
	long	turn;
	long	morning;
	long	evening;

	turn = get_turn() % TURN_A_DAY;
	morning = MORNING_HOUR * TURN_PER_HOUR;
	evening = EVENING_HOUR * TURN_PER_HOUR;

	if( turn < morning )
		return TRUE;
	if( turn >= evening )
		return TRUE;
	return FALSE;
}

/***************************************************************
* ߤΥΥʸ֤
* return : ʸ
***************************************************************/

char	*get_calendar_str( void )
{
	static char	s[127 + 1];
	long	game_day, turn;
	long	year, month, day, hour, minute;
	char	*week;

	game_day = get_game_day();
	turn = get_turn();

	year = (game_day / 360);
	month = (game_day / 30) % 12 + 1;
	day = game_day % 30 + 1;
	hour = (turn / TURN_PER_HOUR) % 24;
	minute = (turn / TURN_PER_MINUTE) % 60;
	week = get_day_of_week_name();

	sprintf( s, MSG_CALENDAR, year, month, day, week, hour, minute );

	return s;
}

/***************************************************************
* ߤΥΥơѥʸ֤
* return : ơѥʸ
***************************************************************/

char	*get_stat_time_str( void )
{
	static char	s[40 + 1];
	long	turn;
	long	hour, minute;

	turn = get_turn();
	hour = (turn / TURN_PER_HOUR) % 24;
	minute = (turn / TURN_PER_MINUTE) % 60;

	sprintf( s, MSG_STAT_TIME, hour, minute );

	return s;
}

/***************************************************************
* ߤΥʸ֤
* return : ʸ֤
***************************************************************/

char	*get_day_of_week_name( void )
{
	switch( get_day_of_week() ){
	case DAY_OF_WEEK_ELEC:
		return MSG_DAY_OF_WEEK_ELEC;
	case DAY_OF_WEEK_PHYS:
		return MSG_DAY_OF_WEEK_PHYS;
	case DAY_OF_WEEK_HEAT:
		return MSG_DAY_OF_WEEK_HEAT;
	case DAY_OF_WEEK_COLD:
		return MSG_DAY_OF_WEEK_COLD;
	case DAY_OF_WEEK_WIND:
		return MSG_DAY_OF_WEEK_MIND;
	case DAY_OF_WEEK_ACID:
		return MSG_DAY_OF_WEEK_ACID;
	case DAY_OF_WEEK_POIS:
		return MSG_DAY_OF_WEEK_POIS;
	case DAY_OF_WEEK_MAX_N:
		break;
	}

	return MSG_NULL;
}

/***************************************************************
* ߤ֤
* return : 
***************************************************************/

day_of_week_t	get_day_of_week( void )
{
	return( (day_of_week_t)(get_game_day() % DAY_OF_WEEK_MAX_N) );
}

