#include "StdAfx.h"
#include "resource.h"
#include "ListPasteDoc.h"
#include "SystemSettings.h"

#include "../GenericLib/Clipboard.h"
#include "../GenericLib/MiscUtil.h"
#include "../GenericLib/SerializeObject.h"

////////////////////////////////////////////////////////////////////////////////

CListPasteDoc::CListPasteDoc()
	: m_list(NULL)
	, m_pWnd(NULL)
	, m_bShowAll(true)
{
	m_dataManager.reset(new ListPasteLib::CDataManager);
	ASSERT(m_dataManager);
}

CListPasteDoc::~CListPasteDoc()
{
}

void CListPasteDoc::Initialize(IList* list, CWnd* pWnd)
{
	ASSERT(!m_list);
	ASSERT(list);
	ASSERT(!m_pWnd);
	ASSERT(pWnd);

	m_list = list;
	m_pWnd = pWnd;
}

////////////////////////////////////////////////////////////////////////////////

size_t CListPasteDoc::GetGroupCount() const
{
	if (!m_dataManager) {
		return 0;
	}

	return m_dataManager->GetGroupCount();
}

bool CListPasteDoc::SetCurrentGroup(size_t index)
{
	if (!m_dataManager) {
		return false;
	}

	return m_dataManager->SetCurrentGroup(index);
}

size_t CListPasteDoc::GetCurrentGroupIndex() const
{
	if (!m_dataManager) {
		return 0;
	}

	return m_dataManager->GetCurrentGroupIndex();
}

CString CListPasteDoc::GetGroupName(size_t index)
{
	if (!m_dataManager) {
		return CString();
	}
	if (index >= GetGroupCount()) {
		return CString();
	}

	return (LPCTSTR)CW2T(m_dataManager->GetGroup(index).GetName().c_str());
}

bool CListPasteDoc::SetGroupName(size_t index, const CString& strName)
{
	if (!m_dataManager) {
		return false;
	}
	if (index >= GetGroupCount()) {
		return false;
	}

	m_dataManager->GetGroup(index).SetName((LPCWSTR)CT2W(strName));

	return true;
}

bool CListPasteDoc::AddGroup(size_t index, const CString& strName)
{
	if (!m_dataManager) {
		return false;
	}

	// HACK: ܂ɒǉ
	if (!m_dataManager->Add((LPCWSTR)CT2W(strName))) {
		return false;
	}

	// ǉꂽO[ṽCfbNX
	size_t added = m_dataManager->GetGroupCount() - 1;
	// 낪w肳ĂAŏI
	if (index >= added) {
		return true;
	}

	// HACK: KvɉĈړ
	// ړ
	INT_PTR move = -static_cast<INT_PTR>(added - index);
	// ړ
	if (!m_dataManager->Move(added, move)) {
		// HACK: sAǉ̂폜ďI
		VERIFY(m_dataManager->Delete(added));
		return false;
	}

	return true;
}

bool CListPasteDoc::MoveGroups(const IndexVec& indices, INT_PTR move)
{
	if (!m_dataManager) {
		return false;
	}
	if (indices.empty()) {
		return false;
	}
	if (move == 0) {
		return false;
	}

	// ΏۃCfbNXɕׂ
	IndexVec idxs = indices;
	std::sort(idxs.begin(), idxs.end());

	// SO[v
	size_t count = m_dataManager->GetGroupCount();
	// (w肳ꂽCfbNXs)
	if (idxs.back() >= count) {
		return false;
	}

	// ֈړ
	if (move > 0) {
		// HACK: Ō̗vfzȂ悤ɂ
		move = min(static_cast<INT_PTR>(count - 1 - idxs.back()), move);
		if (move == 0) {
			return false;
		}

		// HACK: ̃CfbNXȂ悤ɁAォ珇Ɉړ
		for (IndexVec::reverse_iterator it = idxs.rbegin(); it != idxs.rend(); ++it) {
			VERIFY(m_dataManager->Move(*it, move));
		}
	}
	// Oֈړ
	else {
		// HACK: ŏ̗vf擪zȂ悤ɂ
		move = max(-static_cast<INT_PTR>(idxs.front()), move);
		if (move == 0) {
			return false;
		}

		// HACK: ̃CfbNXȂ悤ɁAO珇Ɉړ
		for (IndexVec::iterator it = idxs.begin(); it != idxs.end(); ++it) {
			VERIFY(m_dataManager->Move(*it, move));
		}
	}

	return true;
}

bool CListPasteDoc::DeleteGroup(size_t index)
{
	if (!m_dataManager) {
		return false;
	}
	if (index >= GetGroupCount()) {
		return false;
	}

	return m_dataManager->Delete(index);
}

const ListPasteLib::CDataGroup& CListPasteDoc::GetCurrentGroup() const
{
	ASSERT(m_dataManager);
	return m_dataManager->GetCurrentGroup();
}

ListPasteLib::CDataGroup& CListPasteDoc::GetCurrentGroup()
{
	ASSERT(m_dataManager);
	return m_dataManager->GetCurrentGroup();
}

ListPasteLib::CDataGroup& CListPasteDoc::FindOrCreateGroupByName(const CString& strName)
{
	ASSERT(m_dataManager);

	// O[v
	std::wstring groupName = (LPCWSTR)CT2W(strName);

	// O[vT
	size_t index = m_dataManager->Find(groupName);
	// Ȃ
	if (index == ~0) {
		// O[v𖖔ɒǉ
		m_dataManager->Add(groupName);
		// ̃CfbNX
		index = m_dataManager->GetGroupCount() - 1;
	}

	// O[v擾
	return m_dataManager->GetGroup(index);
}

////////////////////////////////////////////////////////////////////////////////

void CListPasteDoc::Search()
{
	const std::wstring& search = CSystemSettings::Instance().SearchString();
	bool matchFirst            = CSystemSettings::Instance().MatchFirst();

	// 񂪋
	if (search.empty()) {
		// ׂĕ\
		m_bShowAll = true;
		m_dataIndices.clear();
	}
	else {
		m_bShowAll = false;
		// Ō
		m_dataIndices = GetCurrentGroup().Search(search, matchFirst);
	}
}

size_t CListPasteDoc::GetSearchedCount() const
{
	return m_bShowAll ? GetCurrentTexts().size() : m_dataIndices.size();
}

const std::wstring& CListPasteDoc::GetText(int item) const
{
	// ׂẴeLXg
	const ListPasteLib::CDataGroup::WStrings& texts = GetCurrentTexts();

	// texts ł̃CfbNX
	size_t index = Item2DataIndex(item);
	if (index >= texts.size()) {
		static const std::wstring err;
		return err;
	}

	return texts[index];
}

bool CListPasteDoc::Modify(int item, const std::wstring& text)
{
	// texts ł̃CfbNX
	size_t index = Item2DataIndex(item);
	if (index >= GetCurrentTexts().size()) {
		return false;
	}

	// obNAbv
	BackUp();

	// ύX
	return GetCurrentGroup().Modify(index, text);
}

UINT CListPasteDoc::GetSelectedCount() const
{
	ASSERT(m_list);
	return m_list->GetSelectedCount();
}

void CListPasteDoc::Copy()
{
	// HACK: \tsꍇAeLXg CF_HDROP Ă邱Ƃ͂ȂƎv
	// HACK: (eLXg͗̓eLXgAGNXv[ CF_HDROP)
	// HACK: āANbv{[hɃRs[ꍇAeLXg CF_HDROP 𗼕Rs[Ă悢
	// HACK: ̂߁AGetSelectedTexts() ł͂Ȃ GetSelectedTextVec() gpA
	// HACK: CClipboard::SetText() ł͂Ȃ CClipboard::SetTextData() gpĂ

	// IĂeLXg
	std::vector<CString> texts = GetSelectedTextVec();
	if (texts.empty()) {
		return;
	}
	// s؂ŘA
	CString strText = GenericUtility::ConcatenateStrings(texts, _T("\r\n"));
	if (strText.IsEmpty()) {
		return;
	}

	// Nbv{[h
	GenericUtility::CClipboard cb;
	// I[vċɂ
	if (!cb.Open(true, m_pWnd)) {
		return;
	}
	// eLXgf[^ݒ肷
	VERIFY(cb.SetTextData(strText));

	// ׂĂLȃt@CpXł
	if (GenericUtility::AreValidFilePaths(texts)) {
		// t@CƂăNbv{[hɃRs[
		VERIFY(cb.SetFileNameData(texts));
	}
}

bool CListPasteDoc::Paste()
{
	// Nbv{[h當擾
	std::vector<std::wstring> texts = GetTextsFromClipboard();
	if (texts.empty()) {
		return false;
	}

	// ǉʒu
	size_t insertPos = GetSelectedDataIndex();
	if (insertPos == ~0) {
		// 
		insertPos = GetCurrentTexts().size();
	}

	// obNAbv
	BackUp();

	// xɒǉ
	return GetCurrentGroup().Add(insertPos, texts);
}

void CListPasteDoc::Delete()
{
	// HACK: Ŏ擾ł͂
	ListPasteLib::CDataGroup::IndexVec indices = GetAllSelectedDataIndices();

	// obNAbv
	BackUp();

	// HACK: 폜Ώۂ̃CfbNXȂ悤ɁAtɍ폜
	// HACK: (́AAĂȂ\邱Ƃɒ)
	for (ListPasteLib::CDataGroup::IndexVec::reverse_iterator it = indices.rbegin(); it != indices.rend(); ++it) {
		// HACK: DEL L[ςȂŘAč폜ƂAs\
		GetCurrentGroup().Delete(*it);
	}
}

bool CListPasteDoc::PasteOnDrawClipboard()
{
	if (!m_dataManager) {
		return false;
	}
	// HACK: Rs[̂̓y[XgȂ
	if (m_pWnd && m_pWnd->GetSafeHwnd() == ::GetClipboardOwner()) {
		return false;
	}

	size_t nClipboardRecordSize = CSystemSettings::Instance().ClipboardRecordSize();

	// HACK: ɃI[vƎsꍇ̂ŁAgC
	// gC
	static const size_t RETRY = 10;
	// Nbv{[h當擾
	std::vector<std::wstring> texts = GetTextsFromClipboard(nClipboardRecordSize, RETRY);
	if (texts.empty()) {
		return false;
	}

	// TCY
	if (nClipboardRecordSize > 0) {
#if 1
		// HACK: KvȂ͂Aꉞ`FbNĂ
		if (texts.size() > nClipboardRecordSize) {
			texts.resize(nClipboardRecordSize);
		}
#endif

		// HACK: łptH[}X悭Ȃ悤ɁAɍ폜
		// c (ő吔)
		size_t maxSize = nClipboardRecordSize - texts.size();
		// ݂̐
		size_t currentSize = GetCurrentTexts().size();
		// ő吔𒴂Ȃ悤ɁA폜
		while (currentSize > maxSize) {
			VERIFY(GetCurrentGroup().Delete(--currentSize));
		}
	}

	// HACK: obNAbv͎Ȃ

	// JgO[vɒǉ
	if (CSystemSettings::Instance().WatchClipboardMode() == CSystemSettings::WCM_CurrentGroup) {
		// JgO[v̐擪ɒǉ
		return GetCurrentGroup().Add(0, texts);
	}
	// Nbv{[hO[vɒǉ
	else {
		ASSERT(CSystemSettings::Instance().WatchClipboardMode() == CSystemSettings::WCM_ClipboardGroup);
		// Nbv{[hO[v̐擪ɒǉ
		return FindOrCreateGroupByName(GenericUtility::LoadStringRes(IDS_GROUP_NAME_CLIPBOARD)).Add(0, texts);
	}
}

void CListPasteDoc::BackUp(EBackUpID id)
{
	ASSERT(0 <= id && id < BU_Size);

	if (!m_dataManagerBak[id]) {
		m_dataManagerBak[id].reset(new ListPasteLib::CDataManager);
		ASSERT(m_dataManagerBak[id]);
	}

	// HACK: obNAbv (ۂƃRs[)
	// TODO: dvC
	ASSERT(m_dataManager);
	*m_dataManagerBak[id] = *m_dataManager;
}

void CListPasteDoc::ClearBackUp(EBackUpID id)
{
	ASSERT(0 <= id && id < BU_Size);
	m_dataManagerBak[id].reset();
}

void CListPasteDoc::SwapBackUp(EBackUpID id1, EBackUpID id2)
{
	ASSERT(0 <= id1 && id1 < BU_Size);
	ASSERT(0 <= id2 && id2 < BU_Size);

	if (id1 != id2) {
		std::swap(m_dataManagerBak[id1], m_dataManagerBak[id2]);
	}
}

bool CListPasteDoc::Undo(EBackUpID id)
{
	ASSERT(0 <= id && id < BU_Size);

	// obNAbvȂ
	if (!m_dataManagerBak[id]) {
		return false;
	}

	// obNAbvƓւ
	std::swap(m_dataManager, m_dataManagerBak[id]);

	return true;
}

bool CListPasteDoc::CanUndo(EBackUpID id) const
{
	ASSERT(0 <= id && id < BU_Size);
	// obNAbv邩ǂ
	return m_dataManagerBak[id];
}

std::vector<CString> CListPasteDoc::GetSelectedTextVec() const
{
	ASSERT(m_list);
	std::vector<CString> texts;

	// ׂẴeLXg
	const ListPasteLib::CDataGroup::WStrings& txts = GetCurrentTexts();

	POSITION pos = m_list->GetFirstSelectedItemPosition();
	while (pos) {
		// f[^CfbNX
		size_t index = Item2DataIndex(m_list->GetNextSelectedItem(pos));
		if (index >= (int)txts.size()) {
			continue;
		}
		// ΉeLXgǉ
		texts.push_back((LPCTSTR)CW2T(txts[index].c_str()));
	}

	return texts;
}

#if 0
CString CListPasteDoc::GetSelectedTexts() const
{
	ASSERT(m_list);
	CString texts;

	// ׂẴeLXg
	const ListPasteLib::CDataGroup::WStrings& txts = GetCurrentTexts();

	POSITION pos = m_list->GetFirstSelectedItemPosition();
	while (pos) {
		// HACK: ڈȍ~͉s (CR+LF) ŋ؂
		// TODO: 󔒂Lӂȃf[^Ƃ݂ȂȂA󔒂ǂł͂ȂŏǂŔfׂ
		if (!texts.IsEmpty()) {
			texts.Append(_T("\r\n"));
		}

		// f[^CfbNX
		size_t index = Item2DataIndex(m_list->GetNextSelectedItem(pos));
		if (index >= (int)txts.size()) {
			continue;
		}
		// ΉeLXgǉ
		texts.Append(CW2T(txts[index].c_str()));
	}

	return texts;
}
#endif

const ListPasteLib::CDataGroup::WStrings& CListPasteDoc::GetCurrentTexts() const
{
	return GetCurrentGroup().GetTexts();
}

////////////////////////////////////////////////////////////////////////////////

int CListPasteDoc::GetSelectedItem() const
{
	ASSERT(m_list);

	POSITION pos = m_list->GetFirstSelectedItemPosition();
	if (!pos) {
		return -1;
	}

	// IĂŏ̍
	return m_list->GetNextSelectedItem(pos);
}

size_t CListPasteDoc::Item2DataIndex(int item) const
{
	if (item < 0) {
		return ~0;
	}

	// f[^CfbNX
	size_t index = 0;
	// ׂĕ\Ă
	if (m_bShowAll) {
		// Xg̃CfbNX == texts ł̃CfbNX
		index = item;
	}
	else {
		// Xg̃CfbNX == m_dataIndices ł̃CfbNX
		if (item >= (int)m_dataIndices.size()) {
			return ~0;
		}
		index = m_dataIndices[item];
	}

	if (index >= GetCurrentTexts().size()) {
		return ~0;
	}
	return index;
}

size_t CListPasteDoc::GetSelectedDataIndex() const
{
	return Item2DataIndex(GetSelectedItem());
}

ListPasteLib::CDataGroup::IndexVec CListPasteDoc::GetAllSelectedDataIndices() const
{
	ASSERT(m_list);
	ListPasteLib::CDataGroup::IndexVec indices;

	POSITION pos = m_list->GetFirstSelectedItemPosition();
	while (pos) {
		// f[^CfbNXɕϊ
		size_t index = Item2DataIndex(m_list->GetNextSelectedItem(pos));
		// LȂǉ
		if (index != ~0) {
			indices.push_back(index);
		}
	}

	return indices;
}

std::vector<std::wstring> CListPasteDoc::GetTextsFromClipboard(size_t maxTexts, size_t retry)
{
	// Nbv{[h當擾
	CString strText = GenericUtility::CClipboard::GetText(m_pWnd, retry);
	if (strText.IsEmpty()) {
		return std::vector<std::wstring>();
	}

	// HACK: s "\r\n" (CR+LF) łƉ肵Ă

	bool bSkipEmptyLines = CSystemSettings::Instance().SkipEmptyLines();
	bool bTrimSpaces     = CSystemSettings::Instance().TrimSpaces();

	// ׂẴeLXg
	std::vector<std::wstring> texts;
	int curPos = 0;
	// HACK: LF ŕ
	CString token= strText.Tokenize(_T("\n"), curPos);
	// HACK: CR ̂ŁAAso
	while (!token.IsEmpty()) {
		// HACK:  CR ͍폜
		token.TrimRight(_T("\r"));

		// 󔒕g
		if (bTrimSpaces) {
			token.Trim();
		}

		// 󔒍sXLbv
		if (!bSkipEmptyLines || !token.IsEmpty()) {
			texts.push_back((LPCWSTR)CT2W(token));
			// ő吔ɒBI
			if (maxTexts > 0 && texts.size() >= maxTexts) {
				break;
			}
		}

		// ̃g[N
		token = strText.Tokenize(_T("\n"), curPos);
	}

	return texts;
}

////////////////////////////////////////////////////////////////////////////////

namespace {

	/**
	 * CDataManager ̐ݒۑpt@C擾.
	 */
	std::wstring GetDataManagerFilename()
	{
		return GenericUtility::GetStorageFilename(L"ListPasteData.xml");
	}

}	// anonymous namespace

bool CListPasteDoc::Save()
{
	ASSERT(m_dataManager);
	return m_dataManager->Save(GetDataManagerFilename());
}

bool CListPasteDoc::Load()
{
	// CX^X쐬
	// HACK: t@CȂꍇɃZbg邽߁Aɍč쐬
	m_dataManager.reset(new ListPasteLib::CDataManager);
	ASSERT(m_dataManager);

	std::wstring filename = GetDataManagerFilename();
	// HACK: t@CȂ () ́AƂ݂Ȃ
	return !::PathFileExistsW(filename.c_str()) || m_dataManager->Load(filename);
}
