/**
 * @file  DialogPositionSaver.cpp
 * @brief _CAOʒuۑ/NX.
 *
 * @author JIN
 *
 * Copyright (C) 2004- JIN All rights reserved.
 */
#include "stdafx.h"
#include "DialogPositionSaver.h"
#include "MiscUtil.h"

namespace DialogUtility {

namespace {


	/**
	 * ̃TCYɖ߂Ƃ̃EBhEʒu擾.
	 */
	CRect GetWindowNormalPlacement(const CWnd* pWnd)
	{
		if (!pWnd)
			return CRect(0, 0, 0, 0);

		WINDOWPLACEMENT wndpl;
		pWnd->GetWindowPlacement(&wndpl);
		return wndpl.rcNormalPosition;
	}

	/**
	 * ̃TCYɖ߂Ƃ̃EBhEʒuݒ肷.
	 */
	bool SetWindowNormalPlacement(CWnd* pWnd, CRect rect, UINT showCmd = SW_SHOWNORMAL)
	{
		if (!pWnd) {
			return false;
		}
		if (rect.IsRectEmpty()) {
			return false;
		}

		WINDOWPLACEMENT wndpl = { 0 };
		wndpl.length = sizeof(WINDOWPLACEMENT);
		wndpl.showCmd = showCmd;
		wndpl.rcNormalPosition = rect;
		return pWnd->SetWindowPlacement(&wndpl) == TRUE;
	}

}   // anonymous namespace

/////////////////////////////////////////////////////////////////////////////

CDialogPositionSaver::CDialogPositionSaver() : m_rc(CRect(0, 0, 0, 0))
{
}

bool CDialogPositionSaver::Save(CWnd* pWnd)
{
	if (!pWnd) {
		return false;
	}
	m_rc = GetWindowNormalPlacement(pWnd);
	return true;
}

bool CDialogPositionSaver::Restore(CWnd* pWnd)
{
	if (!pWnd) {
		return false;
	}
	return SetWindowNormalPlacement(pWnd, m_rc);
}

/////////////////////////////////////////////////////////////////////////////

bool CListColumnWidthSaver::Save(CListCtrl* pList)
{
	if (!pList) {
		return false;
	}
	int nCount = pList->GetHeaderCtrl()->GetItemCount();
	m_Widths.clear();
	m_Widths.reserve(nCount);
	for (int i = 0; i < nCount; ++i) {
		m_Widths.push_back(pList->GetColumnWidth(i));
	}
	return true;
}

bool CListColumnWidthSaver::Restore(CListCtrl* pList)
{
	if (!pList) {
		return false;
	}
	int nCount = pList->GetHeaderCtrl()->GetItemCount();
	if (nCount != m_Widths.size()) {
		return false;
	}

	GenericUtility::CSuspendRedraw sr(pList);
	for (int i = 0; i < nCount; ++i) {
		pList->SetColumnWidth(i, m_Widths[i]);
	}
	return true;
}

/////////////////////////////////////////////////////////////////////////////

CWndFontSaver::CWndFontSaver() : m_height(0)
{
}

bool CWndFontSaver::Save(CWnd* pWnd)
{
	if (!pWnd) {
		return false;
	}

	CFont* pFont = pWnd->GetFont();
	if (!pFont) {
		return false;
	}

	LOGFONT logfont;
	if (!pFont->GetLogFont(&logfont)) {
		return false;
	}

	m_height = logfont.lfHeight;

	return true;
}

bool CWndFontSaver::Restore(CWnd* pWnd)
{
	if (!pWnd) {
		return false;
	}

	CFont* pFont = pWnd->GetFont();
	if (!pFont) {
		return false;
	}

	LOGFONT logfont;
	if (!pFont->GetLogFont(&logfont)) {
		return false;
	}

	if (logfont.lfHeight == m_height) {
		return true;
	}

	logfont.lfHeight = m_height;
	logfont.lfWidth = 0;

	CFont* pNewFont = new CFont;
	if (!pNewFont) {
		return false;
	}
	if (!pNewFont->CreateFontIndirect(&logfont)) {
		return false;
	}

	pWnd->SetFont(pNewFont);

	return true;
}

}	// namespace DialogUtility
