// OptionDlg.cpp : t@C
//

#include "stdafx.h"
#include "ListPaste.h"
#include "OptionDlg.h"
#include "SystemSettings.h"

namespace {

	/**
	 * WI{^CfbNX EWatchClipboardMode ɕϊ.
	 */
	CSystemSettings::EWatchClipboardMode RadioIndex2WatchClipboardMode(int val)
	{
		switch (val) {
			case CSystemSettings::WCM_None:
			case CSystemSettings::WCM_CurrentGroup:
			case CSystemSettings::WCM_ClipboardGroup:
				return static_cast<CSystemSettings::EWatchClipboardMode>(val);
			default:
				return CSystemSettings::WCM_None;
		}
	}

	/**
	 * EWatchClipboardMode WI{^CfbNXɕϊ.
	 */
	int WatchClipboardMode2RadioIndex(CSystemSettings::EWatchClipboardMode val)
	{
		return val;
	}


}	// anonymous namespace

// COptionDlg _CAO

IMPLEMENT_DYNAMIC(COptionDlg, CDialog)

COptionDlg::COptionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptionDlg::IDD, pParent)
	, m_bTopMost(FALSE)
	, m_bControlIme(FALSE)
	, m_nWatchClipboardMode(0)
	, m_nClipboardRecordSize(0)
	, m_bSkipEmptyLines(FALSE)
	, m_bTrimSpaces(FALSE)
	, m_bTransparentOnInactive(FALSE)
	, m_bTransparentOnDrag(FALSE)
	, m_nTransparentAlpha(64)
{

}

COptionDlg::~COptionDlg()
{
}

void COptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_TOPMOST, m_bTopMost);
	DDX_Check(pDX, IDC_CHECK_CONTROL_IME, m_bControlIme);
	DDX_Radio(pDX, IDC_RADIO_DONT_WATCH_CLIPBOARD, m_nWatchClipboardMode);
	DDX_Text(pDX, IDC_EDIT_CLIPBOARD_RECORD_SIZE, m_nClipboardRecordSize);
	DDX_Check(pDX, IDC_CHECK_SKIP_EMPTY_LINES, m_bSkipEmptyLines);
	DDX_Check(pDX, IDC_CHECK_TRIM_SPACES, m_bTrimSpaces);
	DDX_Check(pDX, IDC_CHECK_TRANSPARENT_ON_INACTIVE, m_bTransparentOnInactive);
	DDX_Check(pDX, IDC_CHECK_TRANSPARENT_ON_DRAG, m_bTransparentOnDrag);
	DDX_Text(pDX, IDC_EDIT_TRANSPARENT_ALPHA, m_nTransparentAlpha);
	DDV_MinMaxByte(pDX, m_nTransparentAlpha, 0, 255);
}


BEGIN_MESSAGE_MAP(COptionDlg, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_DEFAULT, &COptionDlg::OnBnClickedButtonDefault)
END_MESSAGE_MAP()


// COptionDlg bZ[W nh

BOOL COptionDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	////////////////////////////////////////////////////////////////////////////////
	// 

	CSystemSettings& settings = CSystemSettings::Instance();
	// ŏ̐ݒۑĂ
	m_settingsOrg = settings;
	// CSystemSettings ݒ擾
	SetValues(settings);

	UpdateData(FALSE);

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

void COptionDlg::OnOK() 
{
	if (UpdateData()) {
		CSystemSettings& settings = CSystemSettings::Instance();

		// ݒe CSystemSettings ɔf
		settings.SetTopMost(m_bTopMost == TRUE);
		settings.SetControlIme(m_bControlIme == TRUE);
		settings.SetWatchClipboardMode(RadioIndex2WatchClipboardMode(m_nWatchClipboardMode));
		settings.SetClipboardRecordSize(m_nClipboardRecordSize);
		settings.SetSkipEmptyLines(m_bSkipEmptyLines == TRUE);
		settings.SetTrimSpaces(m_bTrimSpaces == TRUE);
		settings.SetTransparentOnInactive(m_bTransparentOnInactive == TRUE);
		settings.SetTransparentOnDrag(m_bTransparentOnDrag == TRUE);
		settings.SetTransparentAlpha(m_nTransparentAlpha);
	}

	CDialog::OnOK();
}

void COptionDlg::OnCancel() 
{
	CDialog::OnCancel();
}

void COptionDlg::OnBnClickedButtonDefault()
{
	// ftHglݒ肷
	SetValues(CSystemSettings());

	UpdateData(FALSE);
}

const CSystemSettings& COptionDlg::SettingsOrg() const
{
	return m_settingsOrg;
}

void COptionDlg::SetValues(const CSystemSettings& settings)
{
	m_bTopMost               = settings.TopMost();
	m_bControlIme            = settings.ControlIme();
	m_nWatchClipboardMode    = WatchClipboardMode2RadioIndex(settings.WatchClipboardMode());
	m_nClipboardRecordSize   = static_cast<UINT>(settings.ClipboardRecordSize());
	m_bSkipEmptyLines        = settings.SkipEmptyLines();
	m_bTrimSpaces            = settings.TrimSpaces();
	m_bTransparentOnInactive = settings.TransparentOnInactive();
	m_bTransparentOnDrag     = settings.TransparentOnDrag();
	m_nTransparentAlpha      = settings.TransparentAlpha();
}
