#!/bin/bash
# _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/
# Name          : hb_logconv_monitor.sh
# Description   : hb_logconv（ログ変換デーモン）のプロセス監視を行う
# Author        : 2009.02.19 k.inoue
# Source        : /etc/ha.d/monitoring/hb_logconv_monitor.sh
# OS  Version   : Red Hat Enterprise Linux Server release 5.2
# HB2 Version   : 2.1.4
#
# License: GNU General Public License (GPL)
# Copyright (c) 2009 NIPPON TELEGRAPH AND TELEPHONE CORPORATION
# _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/

CONVDIR=/usr/share/heartbeat/hb-logconv
RUNDIR=/var/run

# サービス操作情况ファイル
SERVICE_STATE=${RUNDIR}/heartbeat/start_stop_state

# 監視する hb_logconv プロセス
MONITORING_LOGCONV=("/python /usr/share/heartbeat/hb-logconv/hb_logconv.py")

# hb_logconvモニタ プロセス
KILLING_SELF_PROCESS=(hb_logconv_monitor.sh)

# 監視開始待ち時間
MON_LOGCONV_START_WAIT_TIME=30

# 監視間隔
MON_LOGCONV_MONITORING_WAIT_TIME=30

# 監視ログファイル
MON_LOGCONV_MONITORING_LOG=/var/log/hb_logconv_process_monitor.log

# for ocf_log
#. /usr/lib64/heartbeat/ocf-shellfuncs
#HALOG_FILE=/var/log/ha-log

# ログメッセージ
LPPID="hb_logconv daemon Monitor($$)"
INF="INFO"
ERR="ERROR"
WAN="WARNING"
ILOG001="${INF}: monitoring [start]"
ILOG002="${INF}: monitoring [beginning waiting]"
ILOG003="${INF}: monitoring [end]"
ILOG004="${INF}: system reboot now"
ILOG005="${INF}: monitoring [process is alive]"
ELOG001="${ERR}: target monitor hb_logconv is down -- "
WLOG001="${WAN}: killing heartbeat hb_logconv -- "
WLOG002="${WAN}: monitoring [hb_logconv is restart]"

#
# ロギング
#
logging(){
    echo `date` ${LPPID} ${1} >> ${MON_LOGCONV_MONITORING_LOG}

    # for ocf_log
    #ocf_log debug ${LPPID} ${1} >> ${HALOG_FILE} 2>&1
}

#
# モニタ初期化
#
logconv_monitor_start(){

    #
    # 開始時にこのスクリプトが既に実行中の場合は停止する
    #
    for KILL_SELF_PROC in "${KILLING_SELF_PROCESS[@]}"
    do
        ps -ef | grep "${KILL_SELF_PROC}" | grep -v grep | \
          awk -v PID=$$ '$2!=PID {print $2}' | xargs kill -9 > /dev/null 2>&1
    done

    #
    # heartbeatからのシグナルを拒否
    #
    trap '' 1 2 3 15

    #
    logging "${ILOG002} ${MON_LOGCONV_START_WAIT_TIME}sec"
    sleep $MON_LOGCONV_START_WAIT_TIME
}

#
# モニタリング対象プロセスの生存確認
#
isalive_logconv(){

    # モニタリング対象プロセスの生存を確認する
    ISALIVE_FLG=1

    for MON_LOGCONV in "${MONITORING_LOGCONV[@]}"
    do
        pgrep -fl "${MON_LOGCONV}" > /dev/null 2>&1
        PRESULT=$?
        if [ ${PRESULT} -ne 0 ]; then
            K_FLG=`cat ${SERVICE_STATE}`
            if [ ${K_FLG} = "start" ]; then
                logging "${ELOG001} ${MON_LOGCONV}"
            fi
            ISALIVE_FLG=0
            break;
        fi
    done

    return ${ISALIVE_FLG}
}

#
# hb_logconv プロセス関連KILL
#
logconv_killall(){

    # hb_logconv 系のKILL
    for KILL_PROC in "${MONITORING_LOGCONV[@]}"
    do
        pgrep -fl "${KILL_PROC}" > /dev/null 2>&1
        RESULT=$?
        if [ ${RESULT} -eq 0 ]; then
            KILL_PID=`pgrep -fl "${KILL_PROC}" | awk '{print $1}'`
            logging "${WLOG001} ${KILL_PROC}(pid:${KILL_PID})"
            echo ${KILL_PID} | xargs kill -9 > /dev/null 2>&1
        fi
    done
    echo 0
}

#
# hb_logconv のリスタート
#
logconv_restart(){
    ${CONVDIR}/hb_logconv.py -d -c >/dev/null 2>&1
    logging "${WLOG002}"
}

#
# モニタリング
#
logconv_monitor(){

    logconv_monitor_start
    logging "${ILOG001}"

    #
    # Monitoringループ
    #
    while [ 1 ]
    do
        # モニタリング対象プロセスの生存を確認する
        isalive_logconv
        ISALIVE_FLG=$?

        if [ $ISALIVE_FLG -eq 0 ]; then

            # モニタリング対象プロセスが存在していない場合
            K_FLG=`cat ${SERVICE_STATE}`
            if [ ${K_FLG} = "start" ]; then

                # hb_logconv 系のKILL
                logconv_killall

                # hb_logconv を再起動する
                logconv_restart
            fi

        else

            # モニタリング対象プロセスが存在している場合
            logging "${ILOG005}"

        fi

        K_FLG=`cat ${SERVICE_STATE}`
        if [ ${K_FLG} = "stop" ]; then

            # サービスが停止された場合モニタ終了
            break
        fi

        #
        # モニタリング間隔の間、スリープ
        #
        sleep $MON_LOGCONV_MONITORING_WAIT_TIME
    done

    logging "${ILOG003}"
    exit 0
}

#
# Usage
#
logconv_usage(){
    echo "Usage : $KILLING_SELF_PROCESS { monitor | killall } " 1>&2
    return 1
}

#
#
#
case $1 in
    monitor)    logconv_monitor
        exit $? ;;
    killall)    logconv_killall
        exit $? ;;
    *)          logconv_usage
        exit $? ;;
esac
exit 0
