/************************************************************
* Copyright (C) 2007-2008 Masahiko SAWAI All Rights Reserved. 
************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include <wiiremote.h>

static int done;

static 
void
signal_handler(int signal)
{
	done = 1;
}

int main(int argc, char *argv[])
{
	int number, i;
	WRMT_WiiRemote *wiiremotes[WRMT_MAX_DEVICES];
	
	if (WRMT_Init() != 0)
	{
		fprintf(stderr, "WRMT_Init() Faild.\n");
		exit(-1);
	}
	atexit(WRMT_Quit);

	/* Get Number of WiiRemotes */
	number = WRMT_GetNumWiiRemote();
	if (number <= 0)
	{
		fprintf(stderr, "No Wii Remote Found.\n");
		exit(-1);
	}
	fprintf(stderr, "Number of Wii Remote : %d\n", number);

	/* Open and init all WiiRemotes */
	for (i = 0;i < number;i++)
	{
		WRMT_IOReturn rc;

		wiiremotes[i] = WRMT_GetWiiRemoteAt(i);
		rc = WRMT_WiiRemote_Open(wiiremotes[i]);
		if (rc == WRMT_IO_ERROR)
		{
			fprintf(stderr, "WRMT_WiiRemote_Open(%d) Fail.\n", i);
			fprintf(stderr, "\t%s\n", WRMT_GetError());
			exit(-1);
		}
		fprintf(stderr, "[%d] WRMT_WiiRemote_Open() Success.\n", i);

		WRMT_WiiRemote_SetEnabled(wiiremotes[i], WRMT_FUNCTION_IR, 1);
	}

	/* Main Loop */
	signal(SIGINT, signal_handler);
	done = 0;
	while (!done)
	{
		int updated_index, button_state;
		while ((updated_index = WRMT_Poll()) >= 0)
		{
			fprintf(stderr, "[%d]p1(%d, %d, (%d, %d)), p2(%d, %d, (%d, %d))\n",
				updated_index,
				WRMT_WiiRemote_GetState(wiiremotes[updated_index], WRMT_DATA_IR1_FOUND),
				WRMT_WiiRemote_GetState(wiiremotes[updated_index], WRMT_DATA_IR1_SIZE),
				WRMT_WiiRemote_GetState(wiiremotes[updated_index], WRMT_DATA_IR1_X),
				WRMT_WiiRemote_GetState(wiiremotes[updated_index], WRMT_DATA_IR1_Y),
				WRMT_WiiRemote_GetState(wiiremotes[updated_index], WRMT_DATA_IR2_FOUND),
				WRMT_WiiRemote_GetState(wiiremotes[updated_index], WRMT_DATA_IR2_SIZE),
				WRMT_WiiRemote_GetState(wiiremotes[updated_index], WRMT_DATA_IR2_X),
				WRMT_WiiRemote_GetState(wiiremotes[updated_index], WRMT_DATA_IR2_Y)
				);

			/* Exit if HOME is pressed. */
			button_state = WRMT_WiiRemote_GetState(wiiremotes[updated_index], WRMT_DATA_BUTTONS);
			if (button_state & WRMT_MASK_BUTTON_HOME) done = 1;
		}
		fflush(stderr);
		WRMT_Sleep(20);
	}

	/* Close All WiiRemotes */
	fprintf(stderr, "\n");
	for (i = WRMT_GetNumWiiRemote()-1;i >= 0;i--)
	{
		fprintf(stderr, "[%d] WRMT_WiiRemote_Close().\n", i);
		WRMT_WiiRemote_Close(wiiremotes[i]);
	}
	fprintf(stderr, "WRMT_Quit().\n");

	return 0;
}
