/************************************************************
* Copyright (C) 2007 Masahiko SAWAI All Rights Reserved. 
************************************************************/

#import "wiiremote_impl.h"

#import <AvailabilityMacros.h>

#import <Foundation/NSObject.h>
#import <IOBluetooth/objc/IOBluetoothDevice.h>
#import <IOBluetooth/objc/IOBluetoothL2CAPChannel.h>

#define OUTPUT_BUFFER_SIZE (WRMT_BUFFER_SIZE+1)
#define INPUT_BUFFER_SIZE (WRMT_BUFFER_SIZE+1)

@interface WiiRemoteImplement : NSObject
{
	IOBluetoothDevice *device;
	IOBluetoothL2CAPChannel *controlChannel;
	IOBluetoothL2CAPChannel *interruptChannel;
	id controlChannelHandler;
	id interruptChannelHandler;
	BOOL controlChannelState;
	BOOL interruptChannelState;
	unsigned char inputBuffer[INPUT_BUFFER_SIZE];
	unsigned char outputBuffer[OUTPUT_BUFFER_SIZE];
}
- initWithDevice:(IOBluetoothDevice *)aDevice;

- (void)open;
- (void)openControlChannel;
- (void)openInterruptChannel;
- (BOOL)isOpened;
- (void)close;
- (IOReturn)writeToDevice;
- (unsigned char *)inputBuffer;
- (unsigned char *)outputBuffer;
@end
