/************************************************************
* Copyright (C) 2007 Masahiko SAWAI All Rights Reserved. 
************************************************************/
/**
* Button 1 : Enable Force Feedback 
* Button 2 : Disable Force Feedback 
**/

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include <wiiremote.h>

static int done;

static 
void
signal_handler(int i)
{
	done = 1;
}

int main(int argc, char *argv[])
{
	int number;
	WRMT_WiiRemote *wiiremotes[WRMT_MAX_DEVICES];
	int i;
	WRMT_IOReturn rc;
	
	if (WRMT_Init() != 0)
	{
		fprintf(stderr, "WRMT_Init() Faild.\n");
		exit(-1);
	}
	atexit(WRMT_Quit);

	/* Get Number of WiiRemotes */
	number = WRMT_GetNumWiiRemote();
	if (number <= 0)
	{
		fprintf(stderr, "No Wii Remote Found.\n");
		exit(-1);
	}
	fprintf(stderr, "Number of Wii Remote : %d\n", number);

	/* Open and init all WiiRemotes */
	for (i = 0;i < number;i++)
	{
		wiiremotes[i] = WRMT_GetWiiRemoteAt(i);
		rc = WRMT_WiiRemote_Open(wiiremotes[i]);
		if (rc == WRMT_IO_ERROR)
		{
			fprintf(stderr, "WRMT_WiiRemote_Open(%d) Fail.\n", i);
			fprintf(stderr, "\t%s\n", WRMT_GetError());
			exit(-1);
		}
		fprintf(stderr, "[%d] WRMT_WiiRemote_Open() Success.\n", i);

		WRMT_WiiRemote_SetEnabled(wiiremotes[i], WRMT_FUNCTION_CONTINUOUS, 0);
		WRMT_WiiRemote_SetEnabled(wiiremotes[i], WRMT_FUNCTION_MOTION, 0);
		WRMT_WiiRemote_SetEnabled(wiiremotes[i], WRMT_FUNCTION_IR, 0);
	}

	/* Main Loop */
	signal(SIGINT, signal_handler);
	done = 0;
	while (!done)
	{
		int updated_index;
		while ((rc = WRMT_Poll(&updated_index)) == WRMT_IO_SUCCESS)
		{
			int button_state, force_feedback;

			button_state = WRMT_WiiRemote_GetState(wiiremotes[updated_index], WRMT_DATA_BUTTONS);
			if (button_state & WRMT_MASK_BUTTON_HOME) done = 1;
			if ( (button_state & WRMT_MASK_BUTTON_ONE) ||
				(button_state & WRMT_MASK_BUTTON_TWO) )
			{
				force_feedback = WRMT_WiiRemote_GetState(wiiremotes[updated_index], WRMT_DATA_FORCE_FEEDBACK);
				if (force_feedback == 0 && (button_state & WRMT_MASK_BUTTON_ONE))
				{
					WRMT_WiiRemote_SetState(wiiremotes[updated_index], WRMT_DATA_FORCE_FEEDBACK, 1);
				}
				else if (force_feedback == 1 && (button_state & WRMT_MASK_BUTTON_TWO))
				{
					WRMT_WiiRemote_SetState(wiiremotes[updated_index], WRMT_DATA_FORCE_FEEDBACK, 0);
				}
			}
		}

		fflush(stderr);
		WRMT_Sleep(30);
	}

	/* Close All Wii Remote */
	fprintf(stderr, "\n");
	for (i = WRMT_GetNumWiiRemote()-1;i >= 0;i--)
	{
		fprintf(stderr, "WRMT_WiiRemote_Close(%d).\n", i);
		WRMT_WiiRemote_Close(wiiremotes[i]);
	}
	fprintf(stderr, "WRMT_Quit().\n");

	return 0;
}
