/************************************************************
* Copyright (C) 2007 Masahiko SAWAI All Rights Reserved. 
************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include <wiiremote.h>

static int done;

static 
void
signal_handler(int i)
{
	fprintf(stderr, "sigint_handler()\n");
	done = 1;
}

int main(int argc, char *argv[])
{
	int number;
	WRMT_WiiRemote *wiiremotes[WRMT_MAX_DEVICES];
	int i;
	WRMT_IOReturn rc;
	
	if (WRMT_Init() != 0)
	{
		fprintf(stderr, "WRMT_Init() Faild.\n");
		exit(-1);
	}
	atexit(WRMT_Quit);

	number = WRMT_GetNumWiiRemote();
	if (number <= 0)
	{
		fprintf(stderr, "No Wii Remote Found.\n");
		exit(-1);
	}
	fprintf(stderr, "Number of Wii Remote : %d\n", number);

	/* Open and init all WiiRemotes */
	for (i = 0;i < number;i++)
	{
		wiiremotes[i] = WRMT_GetWiiRemoteAt(i);
		rc = WRMT_WiiRemote_Open(wiiremotes[i]);
		if (rc == WRMT_IO_ERROR)
		{
			fprintf(stderr, "WRMT_WiiRemote_Open(%d) Fail.\n", i);
			fprintf(stderr, "\t%s\n", WRMT_GetError());
			exit(-1);
		}
		fprintf(stderr, "[%d] WRMT_WiiRemote_Open() Success.\n", i);

		WRMT_WiiRemote_SetEnabled(wiiremotes[i], WRMT_FUNCTION_CONTINUOUS, 0);
		WRMT_WiiRemote_SetEnabled(wiiremotes[i], WRMT_FUNCTION_MOTION, 0);
		WRMT_WiiRemote_SetEnabled(wiiremotes[i], WRMT_FUNCTION_IR, 0);
	}

	/* Main Loop */
	signal(SIGINT, signal_handler);
	done = 0;
	while (!done)
	{
		int updated_index = -1;
		while ((rc = WRMT_Poll(&updated_index)) == WRMT_IO_SUCCESS)
		{
			int button_state, led_state;
			/* Get device status */
			button_state = WRMT_WiiRemote_GetState(wiiremotes[updated_index], WRMT_DATA_BUTTONS);

			/* LEDs control */
			if ((button_state & WRMT_MASK_BUTTON_PLUS) ||
				(button_state & WRMT_MASK_BUTTON_MINUS))
			{
				led_state = WRMT_WiiRemote_GetState(wiiremotes[updated_index], WRMT_DATA_LEDS);
				if (button_state & WRMT_MASK_BUTTON_PLUS) led_state++;
				if (button_state & WRMT_MASK_BUTTON_MINUS) led_state--;
				if (led_state < 0) led_state = 0;
				else if (led_state > 0x0f) led_state = 0x0f;

				/* Set LEDs status */
				WRMT_WiiRemote_SetState(wiiremotes[updated_index], WRMT_DATA_LEDS, led_state);
			}

			/* Exit if HOME is pressed. */
			if (button_state & WRMT_MASK_BUTTON_HOME) done = 1;
		}
		
		fflush(stderr);
		WRMT_Sleep(30);
	}

	/* Close All WiiRemotes */
	fprintf(stderr, "\n");
	for (i = WRMT_GetNumWiiRemote()-1;i >= 0;i--)
	{
		fprintf(stderr, "WRMT_WiiRemote_Close(%d).\n", i);
		WRMT_WiiRemote_Close(wiiremotes[i]);
	}
	fprintf(stderr, "WRMT_Quit().\n");

	return 0;
}
