/************************************************************
* Copyright (C) 2007 Masahiko SAWAI All Rights Reserved. 
************************************************************/

#import "WiiRemoteImplement.h"
#import "wiiremote_impl.h"
#import "DebugLog.h"

#import <stdio.h>
#import <stdlib.h>

#import <unistd.h>


@implementation WiiRemoteImplement
- initWithDevice:(IOBluetoothDevice *)aDevice
{
	DebugLog("Hello\n");

	self = [super init];
	device = [aDevice retain];
	controlChannel = nil;
	interruptChannel = nil;
	memset(self->outputBuffer, 0, (sizeof(outputBuffer) / sizeof(unsigned char)));
	memset(self->inputBuffer, 0, (sizeof(inputBuffer) / sizeof(unsigned char)));

	DebugLog("Bye\n");
	return self;
}
- (void)dealloc
{
	[self close];
	[device autorelease];
	return [super dealloc];
}

- (void)open
{
	DebugLog("Hello\n");

	[device openConnection:self];
#if 1
	[self openInterruptChannel];
	[self openControlChannel];
#endif

	DebugLog("Bye\n");
}
- (void)close
{
	DebugLog("Hello\n");
	if (interruptChannel)
	{
		[interruptChannel closeChannel];
		[interruptChannel autorelease];
		interruptChannel = nil;
	}
	if (controlChannel)
	{
		[controlChannel closeChannel];
		[controlChannel autorelease];
		controlChannel = nil;
	}
	if ([device isConnected])
	{
		[device closeConnection];
	}
	DebugLog("Bye\n");
}
- (BOOL)isOpened
{
	BOOL result = NO;
	DebugLog("Hello\n");

	if (interruptChannel != nil && controlChannel != nil)
	{
		result = YES;
	}

	DebugLog("Bye\n");
	return result;
}
- (void)openControlChannel
{
	IOReturn ioReturn;
	IOBluetoothL2CAPChannel *newChannel;
	int retry_count = 10;
	DebugLog("Hello\n");

	do
	{
		ioReturn = [device openL2CAPChannelSync:&newChannel withPSM:(BluetoothL2CAPPSM)0x11 delegate:self];
		if (ioReturn == kIOReturnSuccess) break;
		retry_count--;
		usleep(10*1000);
	}
	while (retry_count > 0);

	if (ioReturn == kIOReturnSuccess)
	{
		controlChannel = [newChannel retain];
	}

	DebugLog("Bye\n");
}
- (void)openInterruptChannel
{
	IOReturn ioReturn;
	IOBluetoothL2CAPChannel *newChannel;
	int retry_count;
	DebugLog("Hello\n");

	retry_count = 10;
	do
	{
		ioReturn = [device openL2CAPChannelSync:&newChannel withPSM:(BluetoothL2CAPPSM)0x13 delegate:self];
		if (ioReturn == kIOReturnSuccess) break;
		retry_count--;
		usleep(10*1000);
	}
	while (retry_count > 0);

	if (ioReturn == kIOReturnSuccess)
	{
		interruptChannel = [newChannel retain];
	}

	DebugLog("Bye\n");
}

- (IOReturn)writeToDevice
{
	WRMT_IOReturn result = WRMT_IO_ERROR;
	IOReturn ioReturn;
	assert( (outputBuffer[1] >= WRMT_OUTPUT_REPORT_ID_FIRST) &&
		(outputBuffer[1] <= WRMT_OUTPUT_REPORT_ID_LAST) );
	DebugLog("Hello\n");

	/* check connection status*/
	if (![device isConnected] || controlChannel == nil)
	{
		WRMT_SetError("Device is not connected.");
		return WRMT_IO_ERROR;
	}

	/* send request */
	outputBuffer[0] = 0x52;
	int report_id = outputBuffer[1]; 
	UInt16 report_size = WRMT_Impl_GetOutputReportSize(report_id);
	int retry_count = 10;
	do
	{
		ioReturn = [controlChannel writeSync:outputBuffer
			length:report_size+1];
		if (ioReturn == kIOReturnSuccess) break;
		retry_count--;
		usleep(10*1000);
	}
	while (retry_count > 0);

	if (ioReturn == kIOReturnSuccess)
	{
		result = WRMT_IO_SUCCESS;
	}
	else
	{
		WRMT_SetError("Send Request Failed.");
		result = WRMT_IO_ERROR;
	}

	DebugLog("Bye\n");
	return result;
}

- (unsigned char *)outputBuffer
{
	return outputBuffer+1;
}
- (unsigned char *)inputBuffer
{
	return inputBuffer+1;
}
/**
* callbacks
**/
- (void)connectionComplete:(IOBluetoothDevice *)aDevice
	status:(IOReturn)status
{
	DebugLog("status == 0x%x\n", status);
	[device performSDPQuery:self];
}
- (void)sdpQueryComplete:(IOBluetoothDevice *)aDevice
	status:(IOReturn)status
{
	DebugLog("status == 0x%x\n", status);
#if 0
	[self openControlChannel];
	[self openInterruptChannel];
#endif
}
- (void)l2capChannelData:(IOBluetoothL2CAPChannel*)l2capChannel
	data:(void *)dataPointer
	length:(size_t)dataLength
{
	DebugLog("Hello\n");
	if (l2capChannel == controlChannel)
	{
		DebugLog("controlChannel\n");
	}
	else if (l2capChannel == interruptChannel)
	{
		DebugLog("interruptChannel\n");
		memcpy(inputBuffer, dataPointer, dataLength);
	}
	else
	{
		DebugLog("Unknown channel\n");
	}
	DebugLog("Bye\n");
}
- (void)l2capChannelOpenComplete:(IOBluetoothL2CAPChannel*)l2capChannel status:(IOReturn)error
{
	if (l2capChannel == controlChannel) DebugLog("controlChannel\n");
	else if (l2capChannel == interruptChannel) DebugLog("interruptChannel\n");
	else DebugLog("Unknown Channel\n");
}
- (void)l2capChannelClosed:(IOBluetoothL2CAPChannel*)l2capChannel
{
	if (l2capChannel == controlChannel) DebugLog("controlChannel\n");
	else if (l2capChannel == interruptChannel) DebugLog("interruptChannel\n");
	else DebugLog("Unknown Channel\n");
}
- (void)l2capChannelReconfigured:(IOBluetoothL2CAPChannel*)l2capChannel
{
	if (l2capChannel == controlChannel) DebugLog("controlChannel\n");
	else if (l2capChannel == interruptChannel) DebugLog("interruptChannel\n");
	else DebugLog("Unknown Channel\n");
}
- (void)l2capChannelWriteComplete:(IOBluetoothL2CAPChannel*)l2capChannel refcon:(void*)refcon status:(IOReturn)error
{
	if (l2capChannel == controlChannel) DebugLog("controlChannel\n");
	else if (l2capChannel == interruptChannel) DebugLog("interruptChannel\n");
	else DebugLog("Unknown Channel");
}
- (void)l2capChannelQueueSpaceAvailable:(IOBluetoothL2CAPChannel*)l2capChannel
{
	if (l2capChannel == controlChannel) DebugLog("controlChannel\n");
	else if (l2capChannel == interruptChannel) DebugLog("interruptChannel\n");
	else DebugLog("Unknown Channel");
}
@end
