/************************************************************
* Copyright (C) 2007 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#ifndef DEBUG_LOG_H
#define DEBUG_LOG_H

#ifdef NDEBUG

# if (defined __GNUC__) || ((defined __STDC_VERSION__) &&(__STDC_VERSION__ >= 199901L))
#  define DebugLog(fmt, ...) ((void)(0))
# else
#  define DebugLog
# endif

#else /* DEBUG mode (not defined NDEBUG) */
/**
* Please use C99 compiler to enable DebugLog() output.
**/

#include <stdio.h>
#include <stdarg.h>
#include <string.h>

static
void
DebugLog_Output(const char *file,
		int line,
		const char *func,
		const char *format,
		...)
{
	static const char *DebugLog_ENABLED_FUNCTION_LIST[] = {
		/* wiiremote.h */
/*		"WRMT_SetError", */
/*		"WRMT_GetError", */
		"WRMT_Init",
		"WRMT_Quit",
/*		"WRMT_Sleep", */
/*		"WRMT_Update", */
/*		"WRMT_Poll", */
		"WRMT_GetNumWiiRemote",
		"WRMT_GetWiiRemoteAt",
		"WRMT_WiiRemote_Open",
		"WRMT_WiiRemote_IsOpened",
		"WRMT_WiiRemote_Close",
		"WRMT_WiiRemote_IsEnabled",
		"WRMT_WiiRemote_SetEnabled",
/*		"WRMT_WiiRemote_GetState", */
		"WRMT_WiiRemote_SetState",
		"WRMT_WiiRemote_WriteDataToMemory",
		/* wiiremote.c */
/*		"WRMT_ParseButtonState", */
/*		"WRMT_ParseMotionState", */
/*		"WRMT_ParseIRState", */
/*		"WRMT_ParseReport", */
/*		"WRMT_ClearOutputBuffer", */
/*		"WRMT_OutputToDevice", */
/*		"WRMT_SendControllerStatusRequest", */
/*		"WRMT_SendReportTypeRequest", */
/*		"WRMT_SendDeviceState", */
/*		"WRMT_SendIRParameters", */
/*		"WRMT_SendSpeakerParameters", */
		/* linux/wiiremote_linux_bluez.c */
/*		"IsWiiRemote", */
/*		"WRMT_WiiRemoteImpl_InitWithAddress", */
		/* darwin/WiiRemoteImplement.h */
		"-[WiiRemoteImplement initWithDevice:]",
		"-[WiiRemoteImplement open]",
		"-[WiiRemoteImplement openControlChannel]",
		"-[WiiRemoteImplement openInterruptChannel]",
		"-[WiiRemoteImplement isOpened]",
		"-[WiiRemoteImplement close]",
		"-[WiiRemoteImplement writeToDevice]",
		"-[WiiRemoteImplement inputBuffer]",
		"-[WiiRemoteImplement outputBuffer]",
		/* darwin/WiiRemoteImplement.m */
		"-[WiiRemoteImplement connectionComplete: status:]",
		"-[WiiRemoteImplement sdpQueryComplete: status:]",
		"-[WiiRemoteImplement l2capChannelData: data: length:]",
		"-[WiiRemoteImplement l2capChannelOpenComplete: status:]",
		"-[WiiRemoteImplement l2capChannelClosed:]",
		"-[WiiRemoteImplement l2capChannelReconfigured:]",
		"-[WiiRemoteImplement l2capChannelWriteComplete: refcon: status:]",
		"-[WiiRemoteImplement l2capChannelQueueSpaceAvailable:]",
		/* darwin/WiiRemoteManager.h */
		"-[WiiRemoteManager initWithInquiryLength:]",
		"-[WiiRemoteManager startInquiry]",
		"-[WiiRemoteManager stopInquiry]",
		"-[WiiRemoteManager status]",
		"-[WiiRemoteManager setStatus:newstatus]",
		"-[WiiRemoteManager numberOfWiiRemotes]",
		"-[WiiRemoteManager wiiRemoteAt:]",
		"-[WiiRemoteManager closeAllWiiRemotes]",
		"-[WiiRemoteManager clear]",
		/* darwin/WiiRemoteManager.m */
	};
	va_list argptr;
	int list_length, i, enable;

	va_start(argptr, format);

	list_length = sizeof(DebugLog_ENABLED_FUNCTION_LIST)/sizeof(const char *);
	enable = 0;
	for (i = 0;i < list_length;i++)
	{
		if (strcmp(DebugLog_ENABLED_FUNCTION_LIST[i], func) == 0)
		{
			enable = 1;
			break;
		}
	}

	if (enable)
	{
		fprintf(stderr, "%s(%s:%d) : ", func, file, line);
		vfprintf(stderr, format, argptr);
	}

	va_end(argptr);
}

# define DebugLog(fmt, ...) DebugLog_Output(__FILE__, __LINE__, __func__, fmt, ## __VA_ARGS__)

#endif /* NDEBUG */

#endif /* DEBUG_LOG_H */
