/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                :   2  8 00:43:28 JST 2003
    copyright            : (C) 2003 by kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//using namespace std;
//#include <iostream>

 
#include <qdatetime.h>

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kroneko.h"
#include "option.h"
#include "system.h"

Option*     g_Option = new Option();
QDateTime*  g_CurTime = new QDateTime(  QDateTime::currentDateTime() );
int         g_SecsNext = 0;
bool        g_ViewMode = false;
QString     s_cronVersion;
QString     s_anacVersion;
QString     s_atVersion;

static const char *description =
	I18N_NOOP("Kroneko");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
  { "view", "View Mode", 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

	KAboutData aboutData( "kroneko", I18N_NOOP("Kroneko"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2003, K.Kobayashi", 0, 0, "koba@kroneko.bounceme.net");
	aboutData.addAuthor("K.Kobayashi",0, "koba@kroneko.bounceme.net");
  s_anacVersion = System::anacVersion();
  s_atVersion = System::atVersion();
#ifdef CRON_DILLON
  s_cronVerion = "";
  aboutData.addAuthor("Thanks to dillon's cron", s_cronVersion, 0, 0 );
#else
  s_cronVersion = System::cronVersion();
  aboutData.addAuthor("Thanks to vixie-cron", s_cronVersion, 0, 0 );
#endif
  aboutData.addAuthor("Thanks to anacron", s_anacVersion, 0, 0 );
  aboutData.addAuthor("Thanks to at", s_atVersion, 0, 0 );
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  g_ViewMode = args->isSet( "view" );

  KApplication app;
 
  if (app.isRestored())
  {
    RESTORE(KronekoApp);
  }
  else 
  {
    KronekoApp *kroneko = new KronekoApp();
    kroneko->show();

  }

  return app.exec();
}  
