/***************************************************************************
                          detailDlg.cpp  -  description
                             -------------------
    begin                :   5 22 2003
    copyright            : (C) 2003 by K.Kobayashi
    email                : koba@kroneko.bounceme.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//using namespace std;
//#include <iostream>

// include files for Qt
#include <qlayout.h>
#include <qtextview.h>
#include <qpushbutton.h>
#include <qregexp.h>
//#include <qlistview.h>

// include files for KDE
#include <klocale.h>
#include <ktempfile.h>

// application specific includes
#include "system.h"
#include "option.h"
#include "detailDlg.h"
#include "kronekodoc.h"
#include "kronekoview.h"
#include "docTables.h"
#include "listTabs.h"

extern QDateTime* g_CurTime;
extern Option*    g_Option;

/////////////////////////////////////////////////////////////////////////////
//
// ExeDlg - Execute Dialog

//
// Constructor - 'cron'
//
DetailDlg::DetailDlg( KronekoDoc *doc ) :
  KDialog()
{
  QVBoxLayout* v = new QVBoxLayout( this, marginHint(), spacingHint() );
  {
    // Text View
    QTextView* textView = new QTextView( this );
    textView->setLineWidth( 1 );
    textView->setPaper( QBrush( "WhiteSmoke" ) );
    textView->setMinimumSize( QSize(690, 400) );
    v->addWidget( textView );
    textView->setText( getText( doc ) );
  }
  {
    QHBoxLayout* h = new QHBoxLayout( v, 5 );
    h->addStretch( 1 );
    {
      // OK
      QPushButton* okBtn = new QPushButton( i18n("&OK"), this );
      h->addWidget( okBtn );
      okBtn->setDefault( true );
      connect( okBtn, SIGNAL( clicked() ), this, SLOT( accept() ) );
    }
  }

  setCaption( i18n( "Statistic Information") );

}

QString DetailDlg::getText( KronekoDoc *doc )
{
    QString out;

    // Set Header
    QString s = DetailFile( "Statistic" ).readDetail();
    QString head = s.section( "__HEAD__", 1, 1 );
    head.replace( QRegExp( "__STIME__"), g_CurTime->toString( "yyyy-MM-dd hh:mm" ) );
    head.replace( QRegExp( "__ETIME__"), doc->endExe.toString( "yyyy-MM-dd hh:mm" ) );
    head.replace( QRegExp( "__TCNT__" ), QString().setNum(doc->view->execLvw->childCount()) );
    out = head;

#ifndef CRON_DILLON
    // Set System Cron
    if ( g_Option->useSyscron && ( System::access( g_Option->cronFileSys ) & CAN_READ ) ){
      QString w = s.section( "__SYSCRON__", 1, 1 );
      for( UserTbl* utbl=doc->userTbl.first(); utbl; utbl=doc->userTbl.next() ){
        if ( utbl->dType == CRON && utbl->User == "" ){
          w.replace( QRegExp( "__TTASK__" ), QString().setNum( utbl->itemCnt ) );
          w.replace( QRegExp( "__TEXE__" ), QString().setNum( utbl->exeCnt ) );
          break;
        }
      }
      QString l = "";
      QString w2 = w.section( "__LIST__", 1, 1 );
      for( CronTbl *cr=doc->cronTbl.first(); cr; cr=doc->cronTbl.next() ){
        if ( cr->cronType == CRON_ETC ){
          QString w3 = w2;
          w3.replace( QRegExp( "__USER__" ), cr->User );
          w3.replace( QRegExp( "__TIME__" ), cr->Time );
          w3.replace( QRegExp( "__CMND__"), cr->Cmnd );
          w3.replace( QRegExp( "__ECNT__" ), QString().setNum( cr->exeCnt ) );
          l = l + w3;
        }         
      }
      w.replace( QRegExp( "__LIST__*__LIST__", true, true), l );
      out = out + w;
    }
#endif

    // Set User Cron
    for( UserTbl* utbl=doc->userTbl.first(); utbl; utbl=doc->userTbl.next() ){
      if ( utbl->dType == CRON && utbl->User != "" && utbl->itemCnt > 0 ){
        QString w = s.section( "__USRCRON__", 1, 1 );
        w.replace( QRegExp( "__TTASK__" ), QString().setNum( utbl->itemCnt ) );
        w.replace( QRegExp( "__TEXE__" ), QString().setNum( utbl->exeCnt ) );
        w.replace( QRegExp( "__USER__" ), utbl->User );
        QString l = "";
        QString w2 = w.section( "__LIST__", 1, 1 );
        for( CronTbl *cr=doc->cronTbl.first(); cr; cr=doc->cronTbl.next() ){
          if ( cr->userTbl == utbl ){
          QString w3 = w2;
          w3.replace( QRegExp( "__TIME__" ), cr->Time );
          w3.replace( QRegExp( "__CMND__"), cr->Cmnd );
          w3.replace( QRegExp( "__ECNT__" ), QString().setNum( cr->exeCnt ) );
          l = l + w3;
          }
        }
        w.replace( QRegExp( "__LIST__*__LIST__", true, true), l );
        out = out + w;
      }
    }

    // Set Anacron
    if ( g_Option->useAnacron && ( System::access( g_Option->anacFileSys ) & CAN_READ ) ){
      QString w = s.section( "__ANACRON__", 1, 1 );
      for( UserTbl* utbl=doc->userTbl.first(); utbl; utbl=doc->userTbl.next() ){
        if ( utbl->dType == ANACRON && utbl->User == "" ){
          w.replace( QRegExp( "__TTASK__" ), QString().setNum( utbl->itemCnt ) );
          w.replace( QRegExp( "__TEXE__" ), QString().setNum( utbl->exeCnt ) );
          break;
        }
      }
      QString l = "";
      QString w2 = w.section( "__LIST__", 1, 1 );
      for( AnacTbl *an=doc->anacTbl.first(); an; an=doc->anacTbl.next() ){
        QString w3 = w2;
        w3.replace( QRegExp( "__PERIOD__" ), QString().setNum( an->Prod ) );
        w3.replace( QRegExp( "__DELAY__" ), QString().setNum( an->Dlay ) );
        w3.replace( QRegExp( "__ID__" ), an->Idnt );
        w3.replace( QRegExp( "__CMND__"), an->Cmnd );
        w3.replace( QRegExp( "__ECNT__" ), QString().setNum( an->exeCnt ) );
        l = l + w3;        
      }
      w.replace( QRegExp( "__LIST__*__LIST__", true, true), l );
      out = out + w;
    }

  // Set At
  if ( g_Option->useAt && ( System::atEnable() ) ){
    QStringList ulist;
    for( AtTbl *at=doc->atTbl.first();at; at=doc->atTbl.next() ){
      if ( ulist.find( at->User ) == ulist.end() ){
        ulist << at->User;
      }
    }
    for ( QStringList::Iterator it=ulist.begin(); it != ulist.end(); it++ ){
      int tcnt = 0;
      int ecnt = 0;
      QString w = s.section( "__AT__", 1, 1 );
      w.replace( QRegExp( "__USER__" ), *it );
      QString l = "";
      QString w2 = w.section( "__LIST__", 1, 1 );
      for( AtTbl *at=doc->atTbl.first();at; at=doc->atTbl.next() ){
        if ( at->User == *it ){
          QString w3 = w2;
          w3.replace( QRegExp( "__TIME__" ), at->Time.toString( "yyyy-MM-dd hh:mm" ) );
          w3.replace( QRegExp( "__JNO__" ), QString().setNum( at->Jno ) );
          w3.replace( QRegExp( "__QNO__" ), QString(QChar(at->Qno)) );
          w3.replace( QRegExp( "__CMND__"), at->Cmnd );
          w3.replace( QRegExp( "__ECNT__" ), QString().setNum( at->exeCnt ) );
          tcnt++;
          ecnt = ecnt + at->exeCnt;
          l = l + w3;
        }
      }    
      w.replace( QRegExp( "__TTASK__" ), QString().setNum( tcnt ) );
      w.replace( QRegExp( "__TEXE__" ), QString().setNum( ecnt ) );
      w.replace( QRegExp( "__LIST__*__LIST__", true, true), l );
      out = out + w;
      
    }
  }
#ifndef CRON_DILLON
  if ( System::access( g_Option->logFile ) & CAN_READ  ){
    {
      QString w = s.section( "__LOGHEAD__", 1, 1 );
      w.replace( QRegExp( "__STIME__"), g_CurTime->toString( "yyyy-MM-dd hh:mm" ) );
      w.replace( QRegExp( "__ETIME__"), doc->endLog.toString( "yyyy-MM-dd hh:mm" ) );
      w.replace( QRegExp( "__TCNT__" ), QString().setNum(doc->view->logLvw->childCount()) );
      out = out + w;
    }
    for ( QListViewItemIterator it( doc->view->logLvw ); it.current(); ++it ){
      LogTbl *log = ((TabLvi*)it.current())->logTbl();
      log->flg = false;
    }
    {
      QString w = s.section( "__LOGSTAT__", 1, 1 );
      QString l = "";
      QString w2 = w.section( "__LIST__", 1, 1 );
      for ( QListViewItemIterator it( doc->view->logLvw ); it.current(); ++it ){
        LogTbl *log = ((TabLvi*)it.current())->logTbl();
        if ( ! log->flg &&
             ( log->LogStr.find( "STARTUP" ) == 0  ||
               log->LogStr.find( "RELOAD" ) == 0   ||
               log->LogStr.find( "REPLACE" ) == 0) ) {
          QString lstr = log->LogStr;
          int cnt=0;
          for ( QListViewItemIterator it2( doc->view->logLvw ); it2.current(); ++it2 ){
            LogTbl *log2 = ((TabLvi*)it2.current())->logTbl();
            if ( ! log2->flg && log2->LogStr == lstr) {
              log2->flg = true;
              cnt++;
            }
          }
          if ( cnt ){
            QString w3 = w2;
            w3.replace( QRegExp( "__TYPE__" ), "CRON" );
            w3.replace( QRegExp( "__CMND__" ), lstr );
            w3.replace( QRegExp( "__TEXE__" ), QString().setNum( cnt ) );
            l = l + w3;
          }   
        }
      }
      for ( QListViewItemIterator it( doc->view->logLvw ); it.current(); ++it ){
        LogTbl *log = ((TabLvi*)it.current())->logTbl();
        if ( ! log->flg && log->dType == ANACRON_LOG &&
             log->LogStr.find( QRegExp( "Anacron*started", true, true ) ) == 0 ) {
          int cnt=0;
          for ( QListViewItemIterator it2( doc->view->logLvw ); it2.current(); ++it2 ){
            LogTbl *log2 = ((TabLvi*)it2.current())->logTbl();
            if ( ! log2->flg && log2->dType == ANACRON_LOG &&
               log2->LogStr.find( QRegExp( "Anacron*started", true, true ) ) == 0 ) {
              log2->flg = true;
              cnt++;
            }
          }
          if ( cnt ){
            QString w3 = w2;
            w3.replace( QRegExp( "__TYPE__" ), "ANACRON" );
            w3.replace( QRegExp( "__CMND__" ), "Anacron Start" );
            w3.replace( QRegExp( "__TEXE__" ), QString().setNum( cnt ) );
            l = l + w3;
          }
        }
      }
      for ( QListViewItemIterator it( doc->view->logLvw ); it.current(); ++it ){
        LogTbl *log = ((TabLvi*)it.current())->logTbl();
        if ( ! log->flg && log->dType == AT_LOG ) {
          QString lstr = log->LogStr;
          int cnt=0;
          for ( QListViewItemIterator it2( doc->view->logLvw ); it2.current(); ++it2 ){
            LogTbl *log2 = ((TabLvi*)it2.current())->logTbl();
            if ( ! log2->flg && log2->dType == AT_LOG && log2->LogStr == lstr) {
              log2->flg = true;
              cnt++;
            }
          }
          if ( cnt ){
            QString w3 = w2;
            w3.replace( QRegExp( "__TYPE__" ), "AT" );
            w3.replace( QRegExp( "__CMND__" ), lstr );
            w3.replace( QRegExp( "__TEXE__" ), QString().setNum( cnt ) );
            l = l + w3;
          }
        }
      }
      if ( l != "" ){
        w.replace( QRegExp( "__LIST__*__LIST__", true, true), l );
        out = out + w;
      }
    }
    {
      QString w = s.section( "__LOG_CRON__", 1, 1 );
      QString l = "";
      QString w2 = w.section( "__LIST__", 1, 1 );
      int tcnt = 0;
      for ( QListViewItemIterator it( doc->view->logLvw ); it.current(); ++it ){
        LogTbl *log = ((TabLvi*)it.current())->logTbl();
        if ( ! log->flg && log->dType == CRON_LOG ) {
          QString user = log->User;
          QString lstr = log->LogStr;
          int cnt=0;
          for ( QListViewItemIterator it2( doc->view->logLvw ); it2.current(); ++it2 ){
            LogTbl *log2 = ((TabLvi*)it2.current())->logTbl();
            if ( ! log2->flg && log2->dType == CRON_LOG &&
                 log2->User == user && log2->LogStr == lstr ){
              log2->flg = true;
              cnt++;
              tcnt++;
            }
          }
          if ( cnt ){
            QString w3 = w2;
            w3.replace( QRegExp( "__USER__" ), user );
            w3.replace( QRegExp( "__CMND__" ), lstr.section( QRegExp( "[()]" ), 1, 1 ) );
            w3.replace( QRegExp( "__ECNT__" ), QString().setNum( cnt ) );
            l = l + w3;
          }
        }
      }
      if ( l != "" ){
        w.replace( QRegExp( "__LIST__*__LIST__", true, true), l );
        w.replace( QRegExp( "__TEXE__" ), QString().setNum( tcnt ) );
        out = out + w;
      }
    }
    {
      QString w = s.section( "__LOG_ANACRON__", 1, 1 );
      QString l = "";
      QString w2 = w.section( "__LIST__", 1, 1 );
      int tcnt = 0;
      for ( QListViewItemIterator it( doc->view->logLvw ); it.current(); ++it ){
        LogTbl *log = ((TabLvi*)it.current())->logTbl();
        if ( ! log->flg && log->dType == ANACRON_LOG &&
               ( log->LogStr.find( QRegExp( "Job*started", true, true ) ) == 0 ||
               log->LogStr.find( QRegExp( "Updated*to", true, true ) ) == 0 ) ) {
          QString lstr = log->LogStr;
          if ( lstr.find( "Update" ) == 0 ){
            lstr = lstr.section( " to ", 0, 0 );
          }
          int cnt=0;
          for ( QListViewItemIterator it2( doc->view->logLvw ); it2.current(); ++it2 ){
            LogTbl *log2 = ((TabLvi*)it2.current())->logTbl();
            if ( ! log2->flg && log2->dType == ANACRON_LOG &&
                 log2->LogStr.find(lstr) == 0 ) {
              log2->flg = true;
              cnt++;
              tcnt++;
            }
          }
          if ( cnt ){
            QString w3 = w2;
            w3.replace( QRegExp( "__CMND__" ), lstr );
            w3.replace( QRegExp( "__ECNT__" ), QString().setNum( cnt ) );
            l = l + w3;
          }
        }
      }
      if ( l != "" ){
        w.replace( QRegExp( "__LIST__*__LIST__", true, true), l );
        w.replace( QRegExp( "__TEXE__" ), QString().setNum( tcnt ) );
        out = out + w;
      }
    }
  }
#endif
  return out;
}
