/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "pref.h"

#include <klocale.h>
#include <kfontdialog.h>
#include <kcolordialog.h>
#include <kpushbutton.h>
#include <ktextedit.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qmessagebox.h>

#include "kitafontprefbase.h"
#include "kitaconfig.h"
#include "debugprefbase.h"

using namespace Kita;

KitaPreferences::KitaPreferences()
        : KDialogBase( TreeList, i18n( "Kita Preferences" ),
                       Help | Default | Ok | Apply | Cancel, Ok )
{
    // this is the base class for your preferences dialog.  it is now
    // a Treelist dialog.. but there are a number of other
    // possibilities (including Tab, Swallow, and just Plain)
    QFrame * fontFrame = addPage( i18n( "Font" ), i18n( "Font" ) );
    m_fontPage = new KitaFontPrefPage( fontFrame );

    connect( m_fontPage, SIGNAL( fontChanged( const QFont& ) ),
             SIGNAL( fontChanged( const QFont& ) ) );

    connect( m_fontPage, SIGNAL( threadFontChanged( const QFont& ) ),
             SIGNAL( threadFontChanged( const QFont& ) ) );

    QFrame * colorFrame = addPage( i18n( "Color" ), i18n( "Color" ) );
    m_colorPage = new KitaColorPrefPage( colorFrame );

    QFrame * asciiArtFrame = addPage( i18n( "AsciiArt" ), i18n( "AsciiArt" ) );
    m_asciiArtPage = new Kita::AsciiArtPrefPage( asciiArtFrame );

    QFrame * debugFrame = addPage( i18n( "Debug" ), i18n( "Debug" ) );
    m_debugPage = new DebugPrefPage( debugFrame );
}

KitaFontPrefPage::KitaFontPrefPage( QWidget* parent )
        : KitaFontPrefBase( parent )
{
    connect( fontButton, SIGNAL( clicked() ), SLOT( slotFontButtonClicked() ) );

    connect( threadFontButton, SIGNAL( clicked() ),
             SLOT( slotThreadFontButtonClicked() ) );

    updateButtons();
}

void KitaFontPrefPage::slotFontButtonClicked()
{
    QFont font = fontButton->font();

    if ( KFontDialog::getFont( font, false, this ) == QDialog::Accepted ) {
        emit fontChanged( font );
    }
    updateButtons();
}

void KitaFontPrefPage::slotThreadFontButtonClicked()
{
    QFont font = threadFontButton->font();

    if ( KFontDialog::getFont( font, false, this ) == QDialog::Accepted ) {
        emit threadFontChanged( font );
    }
    updateButtons();
}

void KitaFontPrefPage::updateButtons()
{
    QFont font = KitaConfig::font();
    fontButton->setText( font.family() + " " + QString::number( font.pointSize() ) );
    fontButton->setFont( font );

    QFont threadFont = KitaConfig::threadFont();
    threadFontButton->setText( threadFont.family() + " " + QString::number( threadFont.pointSize() ) );
    threadFontButton->setFont( threadFont );
}

KitaColorPrefPage::KitaColorPrefPage( QWidget *parent )
        : KitaColorPrefBase( parent )
{
    // FIXME: refactoring.
    /*    QPixmap textPixmap( 30, 10 );
        textPixmap.fill( Qt::black );
        colorList->insertItem( textPixmap, "text" );

        QPixmap backPixmap( 30, 10 );
        backPixmap.fill( Qt::white );
        colorList->insertItem( backPixmap, "background" );*/

    QPixmap popupTextPixmap( 30, 10 );
    popupTextPixmap.fill( KitaConfig::popupColor() );
    colorList->insertItem( popupTextPixmap, i18n( "popup text" ) );

    QPixmap popupBackPixmap( 30, 10 );
    popupBackPixmap.fill( KitaConfig::popupBackgroundColor() );
    colorList->insertItem( popupBackPixmap, i18n( "popup background" ) );

    connect( changeButton, SIGNAL( clicked() ),
             SLOT( slotChangeButtonClicked() ) );
}

void KitaColorPrefPage::slotChangeButtonClicked()
{
    int index = colorList->currentItem();

    if ( index == -1 ) {
        return ;
    }

    QColor newColor;
    QColor defaultColor;

    // FIXME: refactoring.
    switch ( index ) {
    case 0:
        defaultColor = KitaConfig::popupColor();
        break;
    case 1:
        defaultColor = KitaConfig::popupBackgroundColor();
        break;
    default:
        return ;
    }

    int result = KColorDialog::getColor( newColor, defaultColor );
    if ( result == KColorDialog::Rejected ) {
        return ;
    }

    QPixmap newPixmap( 30, 10 );
    // FIXME: refactoring.
    switch ( index ) {
    case 0:
        KitaConfig::setPopupColor( newColor );
        newPixmap.fill( newColor );
        colorList->changeItem( newPixmap, i18n( "popup text" ), index );
        break;
    case 1:
        KitaConfig::setPopupBackgroundColor( newColor );
        newPixmap.fill( newColor );
        colorList->changeItem( newPixmap, i18n( "popup background" ), index );
        break;
    default:
        return ;
    }
}

DebugPrefPage::DebugPrefPage( QWidget* parent )
        : DebugPrefBase( parent )
{
    connect( replaceButton, SIGNAL( clicked() ), SLOT( replace() ) );
}

void DebugPrefPage::replace()
{
    QString fromURL = fromURLLine->text();
    QString toURL = toURLLine->text();

    if ( toURL.find( fromURL ) == 0 ) {
        QMessageBox::critical( this, i18n( "replace" ),
                               i18n( "'To' URL must not contain 'From' URL." ) );;
        return ;
    }

    if ( QMessageBox::warning( this, i18n( "replace" ),
                               i18n( "This tool may possibly break thread's info.\n"
                                     "Please create backups of '~/.kde/share/apps/kita/cache'\n"
                                     "and '~/.kde/share/apps/kita/favorites.xml' before performing.\n"
                                     "Are you ready?" ), QMessageBox::Ok,
                               QMessageBox::Cancel | QMessageBox::Default | QMessageBox::Escape ) == QMessageBox::Ok ) {
        FavoriteThreads::replace( fromURL, toURL );
        Kita::Thread::replace( fromURL, toURL );
        KitaThreadInfo::replace( fromURL, toURL );

        QMessageBox::information( this, i18n( "replace" ), i18n( "Complete." ) );
    }
}

AsciiArtPrefPage::AsciiArtPrefPage( QWidget* parent )
        : AsciiArtPrefBase( parent )
{
    connect( saveButton, SIGNAL( clicked() ), SLOT( commit() ) );

    asciiArtText->setText( KitaConfig::asciiArtList().join( "\n" ) );
}

void AsciiArtPrefPage::commit()
{
    QString text = asciiArtText->text();
    QStringList list = QStringList::split( '\n', text );

    KitaConfig::setAsciiArtList( list );
}

#include "pref.moc"
