/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITATHREADVIEW_H_
#define _KITATHREADVIEW_H_

#include "kitathreadviewbase.h"

#include <kparts/browserextension.h>
#include <dom/html_base.h>

#include <qtextbrowser.h>

#include "kita2ch.h"
#include "libkita/thread.h"

class KURL;
class KitaHTMLPart;
class KitaWriteDialog;

#include <qvaluestack.h> // for gcc-2.9x
template <class T> class QValueStack;

namespace Kita
{
    class Access;
    class PopupTextBrowser;
    class ResPopup;
};

namespace KIO
{
    class Job;
};

/**
 *
 * @author Hideki Ikemoto <ikemo@users.sourceforge.jp>
 **/

class KitaThreadView : public KitaThreadViewBase
{
    Q_OBJECT

public:
    KitaThreadView( QWidget* parent, const char* name = 0 );
    ~KitaThreadView();
    const QString threadName() const;
    const KURL threadURL() const;
    void searchNext( const QStringList& input );
    void killJob();
    void focusSearchCombo();

public slots:
    void showThread( const Kita::Thread* thread );
    void setFont( const QFont& font );
    void slotReloadButton();

protected slots:
    void slotDOMNodeActivated( const DOM::Node& node );
    void slotPopupMenu( KXMLGUIClient*, const QPoint&, const KURL&, const QString&, mode_t );
    void slotOpenURLRequest( const KURL&, const KParts::URLArgs& );

private:     // Private attributes
    Kita::Access* m_access;
    Kita::Thread* m_thread;
    KitaHTMLPart* m_threadPart;
    Kita::PostInfo m_postInfo;
    Kita::ResPopup* m_popup;

    void insertSearchCombo();
    KURL filterReadCGI( const KURL& );
    void setSubjectLabel( const QString& boardName, const QString& threadName );
    KitaWriteDialog* openDialog( const Kita::PostInfo& info );
    const QString footer() const;
    QStringList parseSearchQuery( const QString& input ) const;
    void update( const QString& result );
    void updateButton();

private slots:
    void slotSearchButton();
    void slotHighLightenButton( bool yes );
    void slotOnURL( const QString& url );
    void slotPostStarted( KIO::Job*, const Kita::PostInfo& );
    void slotBookmarkButtonClicked( bool on );
    void slotWriteButtonClicked();
    void slotShowErrorDialog( const QString& input, const KURL& urlOfInput = 0 );
    void hidePopup();

signals:
    void showThreadCompleted( const KURL& threadUrl );
    void datURLRedirected( const KURL& newDatURL );
    void signalChangeStatusbar( const QString& );
    void postResponse( const QString& response, const KURL& bbscgi = KURL() );
    //re-impl signals of KParts::Browserextension of KHTMLPart
    void openURLRequest( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs() );
    void createNewWindow( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs() );
    void setLocationBarURL( const QString& url );
    void enableAction( const char* name, bool enabled );
    void popupMenu( KXMLGUIClient*, const QPoint&, const KURL&, const QString&, mode_t );
    void thread( const Kita::Thread* );
    void writeSucceeded();
    void bookmarked( const Kita::Thread*, bool on );
};

namespace Kita
{
    class PopupTextBrowser : public QTextBrowser
    {
    public:
        PopupTextBrowser( QFrame* frame );
        ~PopupTextBrowser();
    };

    class ResPopup : public QFrame
    {
        Kita::PopupTextBrowser* m_browser;
    public:
        ResPopup( KHTMLView* view );
        ~ResPopup();
        void setText( QString& str );
        void adjustSize();
    };
}

#endif
