/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "thread.h"

#include <config.h>

#include <stdlib.h>
#include <unistd.h>

#include <kurl.h>
#include <kdebug.h>
#include <kprotocolmanager.h>
#include <kglobal.h>
#include <kstandarddirs.h>

#include <kio/slaveconfig.h>
#include <kio/jobclasses.h>
#include <kio/scheduler.h>
#include <kio/netaccess.h>

#include <qwidget.h>
#include <qapplication.h>
#include <qregexp.h>

#include "board.h"
#include "kita_misc.h"
#include "qcp932codec.h"
#include "threadinfo.h"

using namespace Kita;

QDict<Thread>* Thread::m_threadDict = 0;

Thread::Thread()
{}

Thread::Thread( const QString& datURL, const QString& threadName )
        : m_datURL( datURL ), m_threadName( threadName )
{}

Thread::~Thread()
{}

const QString& Thread::datURL() const
{
    return m_datURL;
}

const QString Thread::url() const
{
    return datToThread( m_datURL );
}

const QString Thread::datID() const
{
    return KURL( m_datURL ).filename().section( ".", 0, 0 );
}

int Thread::resNum() const
{
    return KitaThreadInfo::resNum( m_datURL );
}

const QString& Thread::name() const
{
    if ( ! Kita::Thread::getByURL( m_datURL ) ->m_threadName.isEmpty() ) {
        return Kita::Thread::getByURL( m_datURL ) ->m_threadName;
    }
    return m_threadName;
}

void Thread::setResNum( int resNum )
{
    KitaThreadInfo::setResNum( m_datURL, resNum );
}

const QString& Thread::boardName() const
{
    Board * board = Board::getByURL( boardURL() );
    return board->name();
}

const QString Thread::boardURL() const
{
    return datToBoard( m_datURL );
}

const QString Thread::boardID() const
{
    return KURL( datToBoard( m_datURL ) ).fileName();
}

Thread* Thread::getByURL( const QString& datURL )
{
    if ( m_threadDict == 0 ) {
        m_threadDict = new QDict<Thread>();
    }

    if ( m_threadDict->find( datURL ) ) {
        return m_threadDict->find( datURL );
    }

    Thread* newThread = new Thread( datURL );
    m_threadDict->insert( datURL, newThread );

    return newThread;
}

void Thread::setName( const QString& datURL, const QString& threadName )
{
    if ( datURL.isNull() ) {
        return ;
    }

    if ( m_threadDict == 0 ) {
        m_threadDict = new QDict<Thread>();
    }

    if ( m_threadDict->find( datURL ) ) {
        Thread * thread = getByURL( datURL );
        thread->m_threadName = threadName;
    } else {
        Thread* newThread = new Thread( datURL, threadName );
        m_threadDict->insert( datURL, newThread );
    }

    return ;
}

void Thread::replace( const QString& fromURL, const QString& toURL )
{
    QDictIterator<Kita::Thread> it( *m_threadDict );
    for( ; it.current(); ++it ) {
        QString url = it.currentKey();
        Kita::Thread* thread = it.current();
        if ( url.find( fromURL ) == 0 ) {
            m_threadDict->remove( url );
            url = url.replace( 0, fromURL.length(), toURL );
            thread->m_datURL = url;
            Kita::Board::replace( fromURL, toURL );
            m_threadDict->insert( url, thread );
            it.toFirst();
        }
    }
}

NullThread::NullThread()
{}

NullThread::~NullThread()
{}
