/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "boardtest.h"

using namespace Kita;

void BoardTest::setUp()
{
    Board::setName( "http://pc.2ch.net/linux/", "Linux" );
    m_share1 = Board::getByURL( "http://pc.2ch.net/linux/" );

    Board::setName( "http://pc.2ch.net/unix/", "U**x" );
    m_share2 = Board::getByURL( "http://pc.2ch.net/unix/" );

    Board::setName( "http://pc.2ch.net/unix/", "Unix" );
    m_share3 = Board::getByURL( "http://pc.2ch.net/unix/" );

    m_null = Board::getByURL( QString::null );
}

void BoardTest::tearDown()
{
    delete m_normal;
}

void BoardTest::testID()
{
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), m_share1->id() );
    CPPUNIT_ASSERT_EQUAL( QString( "unix" ), m_share2->id() );
    CPPUNIT_ASSERT_EQUAL( QString( "unix" ), m_share3->id() );
    CPPUNIT_ASSERT_EQUAL( QString::null, m_null->id() );
}

void BoardTest::testName()
{
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), m_share1->name() );
    CPPUNIT_ASSERT_EQUAL( QString( "Unix" ), m_share2->name() );
    CPPUNIT_ASSERT_EQUAL( QString( "Unix" ), m_share3->name() );
    CPPUNIT_ASSERT_EQUAL( QString::null, m_null->name() );
}

void BoardTest::testSubjectTxtURL()
{
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/subject.txt" ),
                          m_share1->subjectTxtURL().url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/unix/subject.txt" ),
                          m_share2->subjectTxtURL().url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/unix/subject.txt" ),
                          m_share3->subjectTxtURL().url() );
    CPPUNIT_ASSERT_EQUAL( QString::null, m_null->subjectTxtURL().url() );
}

void BoardTest::testURL()
{
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/"),
                          m_share1->url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/unix/"),
                          m_share2->url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/unix/"),
                          m_share3->url() );
    CPPUNIT_ASSERT_EQUAL( QString::null, m_null->url() );
}

void BoardTest::testStaticName()
{
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), Kita::Board::getName( "http://pc.2ch.net/linux/" ) );
    CPPUNIT_ASSERT_EQUAL( QString( "Unix" ), Kita::Board::getName( "http://pc.2ch.net/unix/" ) );
    CPPUNIT_ASSERT_EQUAL( QString::null, Kita::Board::getName( QString::null ) );
}

void BoardTest::testReplace()
{
    Kita::Board::replace( QString( "http://pc.2ch.net/linux/" ), QString( "http://pc3.2ch.net/linux/" ) );
    Kita::Board* board = Kita::Board::getByURL( "http://pc3.2ch.net/linux/" );
    
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), board->id() );
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), board->name() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc3.2ch.net/linux/subject.txt" ),
                          board->subjectTxtURL().url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc3.2ch.net/linux/"),
                          board->url() );
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), Kita::Board::getName( "http://pc3.2ch.net/linux/" ) );

    Kita::Board::replace( QString( "http://pc3.2ch.net/linux/" ), QString( "http://pc.2ch.net/linux/" ) );
}
