/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "kita_misc.h"

#include <kurl.h>
#include <qregexp.h>

QString Kita::datToBoard( const QString& datURL )
{
    KURL url( datURL );
    return KURL( url, "../" ).url();
}

QString Kita::datToThread( const QString& datURL )
{
    // http://<host>/<board>/dat/<datname>.dat
    KURL url( datURL );
    QString protocol = url.protocol();
    QString host = url.host();

    QStringList list = QStringList::split( ".", url.fileName() );
    if ( list.size() != 2 ) {
        return "";
    }
    QString datName = list[ 0 ];

    url.cd( ".." );
    if ( url.fileName() != "dat" ) {
        return "";
    }

    url.cd( ".." );
    QString board = url.fileName();

    url.cd( ".." );
    if ( url.fileName() != "" ) {
        return "";
    }

    KURL newURL;
    newURL.setProtocol( protocol );
    newURL.setHost( host );

    // FIXME: TOOOOOOOOOOOOOOOOOOOOOO ugly.
    QRegExp host_machibbs( ".*\\.machi\\.to" );
    if ( host_machibbs.search( host ) != -1 ) {
        newURL.addPath( "/bbs/read.pl" );
        newURL.addQueryItem( "BBS", board );
        newURL.addQueryItem( "KEY", datName );
    } else {
        newURL.addPath( QString( "/test/read.cgi/%2/%3/" )
                        .arg( board ).arg( datName ) );
    }

    return newURL.url();
}

QString Kita::threadToDat( const QString& threadURL )
{
    KURL url( threadURL );
    QString filename = url.fileName();
    QString protocol = url.protocol();
    QString host = url.host();

    url.cd( ".." );
    QString board = url.fileName();

    url.cd( ".." );
    if ( url.path() != "/test/read.cgi" ) {
        return "";
    }

    KURL newURL;
    newURL.setProtocol( protocol );
    newURL.setHost( host );
    newURL.addPath( QString( "/%1/dat/%2.dat" )
                    .arg( board ).arg( filename ) );

    return newURL.url();
}

QString Kita::boardToSubject( const QString& boardURL )
{
    KURL url( boardURL );
    url.addPath( "subject.txt" );
    return url.url();
}

QString Kita::subjectToBoard( const QString& subjectURL )
{
    return KURL( subjectURL, "." ).url();
}

QString Kita::datToCache( const QString& datURL )
{
    // http://<host>/<board>/dat/<datname>.dat
    KURL url( datURL );
    QString protocol = url.protocol();
    QString host = url.host();
    QString filename = url.fileName();

    url.cd( ".." );
    if ( url.fileName() != "dat" ) {
        return "";
    }

    url.cd( ".." );
    QString board = url.fileName();

    url.cd( ".." );
    if ( url.fileName() != "" ) {
        return "";
    }

    return QString( "%1/%2/%3" ).arg( host ).arg( board ).arg( filename );
}

QString Kita::httpToK2ch( const QString& httpURL )
{
    KURL url( httpURL );
    url.setProtocol( "k2ch" );

    return url.url();
}

QString Kita::unescape( const QString& str )
{
    QString ret = str;
    return ret.replace( "&lt;", "<" ).replace( "&gt;", ">" ).replace( "&amp;", "&" );
}
