/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "cache.h"

#include <kurl.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kprotocolmanager.h>

using namespace Kita;

QString Cache::baseDir( const KURL& url )
{
    QString dir;
    if ( url.protocol() == "k2ch" ) {
        dir = KGlobal::dirs() ->saveLocation( "cache", "k2ch" );
    } else {
        dir = KProtocolManager::cacheDir();
    }
    if ( dir[ dir.length() - 1 ] != '/' )
        dir += "/";

    return dir;
}

QString Cache::subDir( const QString& host )
{
    int l = host.length();
    for ( int i = 0; i < l; i++ ) {
        if ( host[ i ].isLetter() && ( host[ i ] != 'w' ) ) {
            return QString( host[ i ] );
        }
    }
    return "0";
}

QString Cache::hashString( const KURL& url )
{
    unsigned long hash = 0x00000000;
    QCString u = url.url().latin1();
    for ( int i = u.length(); i--; ) {
        hash = ( hash * 12211 + u[ i ] ) % 2147483563;
    }

    QString ret;
    ret.sprintf( "%08lx", hash );

    return ret;
}

// original is in http.cc
QString Cache::getPath( const KURL& url )
{
    QString path = url.path();
    path.replace( QChar( '/' ), QChar( '_' ) );

    QString host = url.host().lower();

    return baseDir( url ) + subDir( host ) + "/" + host + path + '_' + hashString( url );
}
