/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITABOARD_H
#define KITABOARD_H

#include <kurl.h>

#include <qptrlist.h>
#include <qxml.h>
#include <qdict.h>

#include "thread.h"

/**
@author Hideki Ikemoto
*/

namespace Kita
{
    class Thread;

    class Board
    {
        QString m_boardURL;
        QString m_boardName;
        static QDict<Board>* m_boardDict;
        Board( const QString& boardURL, const QString boardName = QString::null );
        int type() const;
        
    protected:
        Board();
    public:
        ~Board();
        const KURL subjectTxtURL() const;
        const QString& url() const;
        const QString& name() const;
        const QString id() const;
        const QPtrList<Thread> getThreadList() const;

        // Factory method
        static Board* getByURL( const QString& boardURL );
        static void setName( const QString& boardURL, const QString& boardName );
        static void replace( const QString& fromURL, const QString& toURL );

        static const QString& getName( const QString& boardURL );
    };

    class NullBoard : public Board
    {
    public:
        NullBoard();
        ~NullBoard();
    };
};

#endif
