/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITASUBJECTVIEW_H_
#define _KITASUBJECTVIEW_H_

#include <qwidget.h>
#include <kurl.h>
#include "threadlistview.h"
#include "part/kita2ch.h"
#include "libkita/board.h"

class KListViewItem;

/**
 *
 * @author Hideki Ikemoto <ikemo@users.sourceforge.jp>
 **/
class KitaSubjectView : public Kita::ThreadListView
{
    Q_OBJECT

public:
    KitaSubjectView( QWidget* parent, const char* name = 0 );
    ~KitaSubjectView();
    const QString boardURL();
    const QString boardName();

public slots:
    void reloadSubject();
    void loadBoard( const Kita::Board* board );
    void setFont( const QFont& font );
    void updateThread( const Kita::Thread* thread );

private:
    const Kita::Board* m_board;

private slots:
    void loadThread( QListViewItem* item );
    void slotContextMenuRequested( QListViewItem*, const QPoint&, int );
    void slotReloadButton();
    void slotMouseButtonClicked( int, QListViewItem* );

signals:
    void loadBoardCompleted( const KURL& );
    void showThreadRequested( const Kita::Thread* thread, bool withNewTab );
};

#endif
