/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "k2ch_articlefiletest.h"
#include "../k2ch_articlefile.h"
#include <cppunit/TestCaller.h>

void K2chArticleFileTest::setUp()
{
  m_empty = new K2chArticleFile();
  m_empty->parse( "()" );

  m_one = new K2chArticleFile();
  m_one->parse( "((\"1000000000\" :seen 100 :access-time (16122 26923 0)))" );

  m_many = new K2chArticleFile();
  m_many->parse( "((\"1000000000\" :seen 100 :access-time (16122 26923 0))"
                 "(\"999999999\" :seen -1 :access-time (16122 26778 0))"
                 "(\"1234567890\" :seen 999 :access-time (16205 63250 0)))" );
}

void K2chArticleFileTest::tearDown()
{
  delete m_empty;
  delete m_one;
  delete m_many;
}

void K2chArticleFileTest::testCount()
{
  CPPUNIT_ASSERT_EQUAL( 0, m_empty->count() );
  CPPUNIT_ASSERT_EQUAL( 1, m_one->count() );
  CPPUNIT_ASSERT_EQUAL( 3, m_many->count() );
}

void K2chArticleFileTest::testName()
{
  CPPUNIT_ASSERT_EQUAL( QString( "1000000000" ), m_one->item( 0 ).name() );

  CPPUNIT_ASSERT_EQUAL( QString( "1000000000" ), m_many->item( 0 ).name() );
  CPPUNIT_ASSERT_EQUAL( QString( "999999999" ),  m_many->item( 1 ).name() );
  CPPUNIT_ASSERT_EQUAL( QString( "1234567890" ), m_many->item( 2 ).name() );
}

void K2chArticleFileTest::testSeen()
{
  CPPUNIT_ASSERT_EQUAL( 100, m_one->item( 0 ).seen() );

  CPPUNIT_ASSERT_EQUAL( 100, m_many->item( 0 ).seen() );
  CPPUNIT_ASSERT_EQUAL(  -1, m_many->item( 1 ).seen() );
  CPPUNIT_ASSERT_EQUAL( 999, m_many->item( 2 ).seen() );
}

void K2chArticleFileTest::testAccessTime()
{
  CPPUNIT_ASSERT_EQUAL( (time_t)1056598315, m_one->item( 0 ).accessTime() );

  CPPUNIT_ASSERT_EQUAL( (time_t)1056598315, m_many->item( 0 ).accessTime() );
  CPPUNIT_ASSERT_EQUAL( (time_t)1056598170, m_many->item( 1 ).accessTime() );
  CPPUNIT_ASSERT_EQUAL( (time_t)1062074130, m_many->item( 2 ).accessTime() );
}

void K2chArticleFileTest::testToString()
{
  CPPUNIT_ASSERT_EQUAL( QString( "()" ), m_empty->toString() );

  CPPUNIT_ASSERT_EQUAL( QString( "((\"1000000000\" :seen 100 :access-time (16122 26923 0)))" ),
                        m_one->toString() );

  CPPUNIT_ASSERT_EQUAL( QString( "((\"1000000000\" :seen 100 :access-time (16122 26923 0))"
                                 "(\"999999999\" :seen -1 :access-time (16122 26778 0))"
                                 "(\"1234567890\" :seen 999 :access-time (16205 63250 0)))" ),
                        m_many->toString() );
}
