/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KITATHREAD_H
#define KITATHREAD_H

#include <kurl.h>

#include <qobject.h>
#include <qxml.h>
#include <qdict.h>

namespace KIO {
  class Job;
};

namespace Kita {

/**
@author Hideki Ikemoto
*/
  class Board;
  class BoardXmlParser;

  class Thread
  {
    KURL m_datURL;
    QString m_threadName;
    int m_resNum;
  public:
    Thread();
    Thread( const Thread& obj );
    Thread( const KURL& datURL, const QString& threadName = QString::null, int resNum = 0 );
    ~Thread();
    Thread& operator=( const Thread& obj );
    const KURL& datURL() const;
    const QString url() const;
    const QString datID() const;
    int resNum() const;
    const QString& name() const;
    void setName(const QString& name) { m_threadName = name; }
    void setResNum(int resNum) { m_resNum = resNum; }
    const QString& boardName() const;
    const QString boardURL() const;
    const QString boardID() const;

    const QString toXmlFragment() const;
    static Thread fromXml( const QString& xml );
  };

  class ThreadFactory
  {
  public:
    static void insertThread( Thread& thread );
    static Thread* getThread( QString& datURL );
  private:
    ThreadFactory() {};
    ~ThreadFactory() {};
    static ThreadFactory* instance;
    QDict<Thread> m_dict;
  };

  class ThreadXmlParser : public QXmlDefaultHandler
  {
    QString m_datUrlStr;
    QString m_threadName;
    int m_resNum;
    Board* m_board;
    Thread m_thread;
    BoardXmlParser* m_boardParser;

    QString m_characters;

    bool m_inBoard;
    bool m_isValid;
    bool m_inThread;
  public:
    ThreadXmlParser() : m_boardParser(0), m_inBoard(false), m_isValid(false), m_inThread(false) {};
    ~ThreadXmlParser() {};
    bool startElement( const QString& namespaceURI, const QString& localName, const QString& qName, const QXmlAttributes& atts );
    bool endElement( const QString& namespaceURI, const QString& localName, const QString& qName );
    bool characters( const QString& ch );
    bool isValid() const { return m_isValid; }
    Thread getThread() const { return m_thread; }
  };

  class ThreadAccess : public QObject {
    Q_OBJECT

    Thread m_thread;
    KIO::Job* m_currentJob;
    QCString m_threadData;
    QString m_header;
  public:
    ThreadAccess( const Thread& thread ) : m_thread(thread) {};
    ~ThreadAccess() {};
    QString get();
    void killJob();
    int serverTime();
  private:
    void enter_loop();
  private slots:
    void slotReceiveThreadData( KIO::Job* job, const QByteArray& data );
    void slotRedirection( KIO::Job* job, const KURL& );
    void slotThreadResult( KIO::Job* job );
  signals:
    void redirection( const QString& );
  };
};

#endif
