/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef THREADTEST_H
#define THREADTEST_H

#include <cppunit/extensions/HelperMacros.h>
#include <../thread.h>

/**
@author Hideki Ikemoto
*/
class ThreadTest : public CppUnit::TestFixture {
    CPPUNIT_TEST_SUITE( ThreadTest );
    CPPUNIT_TEST( testDatURL );
    CPPUNIT_TEST( testURL );
    CPPUNIT_TEST( testDatID );
    CPPUNIT_TEST( testResNum );
    CPPUNIT_TEST( testName );
    CPPUNIT_TEST( testBoardName );
    CPPUNIT_TEST( testBoardURL );
    CPPUNIT_TEST( testBoardID );
    CPPUNIT_TEST_SUITE_END();

    Kita::Thread *m_normal, *m_noboard;
    Kita::Thread m_fromxml, m_fromxml2, m_fromxml3;  // FIXME: pointerˤ٤
public:
    void setUp();
    void tearDown();

    void testDatURL();
    void testURL();
    void testDatID();
    void testResNum();
    void testName();
    void testBoardName();
    void testBoardURL();
    void testBoardID();
};

#endif
