/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "threadtest.h"
#include "../board.h"

using namespace Kita;

void ThreadTest::setUp()
{
    Kita::Board::setName( "http://pc.2ch.net/linux/", "Linux" );
    m_normal = new Thread( 
    KURL( "http://pc.2ch.net/linux/dat/1069738960.dat" ),
    "Kita - 2ch client for KDE",
    0 );

    m_noboard = new Thread( KURL( "http://pc.2ch.net/linux/dat/1069738960.dat" ),
    "Kita - 2ch client for KDE",
    0 );

    m_fromxml = Thread::fromXml( "<thread xmlns=\"http://kita.sourceforge.jp/ns/thread\">\n"
    "<daturl>http://pc.2ch.net/linux/dat/1022744633.dat</daturl>\n"
    "<name>2ch browser thread</name>\n"
    "<resnum>700</resnum>\n"
    "<board xmlns=\"http://kita.sourceforge.jp/ns/board\">\n"
    "<url>http://pc.2ch.net/linux/</url>\n"
    "<name>Linux</name>\n"
    "</board>\n"
    "</thread>\n" );

    m_fromxml2 = Thread::fromXml( m_fromxml.toXmlFragment() );

    m_fromxml3 = Thread::fromXml( "<thread xmlns=\"http://kita.sourceforge.jp/ns/thread\">\n"
    "  <daturl>http://pc.2ch.net/linux/dat/1022744633.dat</daturl>\n"
    "  <name>2ch browser thread</name>\n"
    "  <resnum>700</resnum>\n"
    "  <board xmlns=\"http://kita.sourceforge.jp/ns/board\">\n"
    "    <url>http://pc.2ch.net/linux/</url>\n"
    "    <name>Linux</name>\n"
    "  </board>\n"
    "</thread>\n" );
}

void ThreadTest::tearDown()
{
    delete m_normal;
    delete m_noboard;
}

void ThreadTest::testDatURL()
{
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/dat/1069738960.dat"),
                          m_normal->datURL().url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/dat/1069738960.dat"),
                          m_noboard->datURL().url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/dat/1022744633.dat"),
                          m_fromxml.datURL().url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/dat/1022744633.dat"),
                          m_fromxml2.datURL().url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/dat/1022744633.dat"),
                          m_fromxml3.datURL().url() );
}

void ThreadTest::testURL()
{
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/test/read.cgi/linux/1069738960/"),
                          m_normal->url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/test/read.cgi/linux/1069738960/"),
                          m_noboard->url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/test/read.cgi/linux/1022744633/"),
                          m_fromxml.url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/test/read.cgi/linux/1022744633/"),
                          m_fromxml2.url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/test/read.cgi/linux/1022744633/"),
                          m_fromxml3.url() );
}

void ThreadTest::testDatID()
{
    CPPUNIT_ASSERT_EQUAL( QString( "1069738960" ), m_normal->datID() );
    CPPUNIT_ASSERT_EQUAL( QString( "1069738960" ), m_noboard->datID() );
    CPPUNIT_ASSERT_EQUAL( QString( "1022744633" ), m_fromxml.datID() );
    CPPUNIT_ASSERT_EQUAL( QString( "1022744633" ), m_fromxml2.datID() );
    CPPUNIT_ASSERT_EQUAL( QString( "1022744633" ), m_fromxml3.datID() );
}

void ThreadTest::testResNum()
{
    CPPUNIT_ASSERT_EQUAL( 0, m_normal->resNum() );
    CPPUNIT_ASSERT_EQUAL( 0, m_noboard->resNum() );
    CPPUNIT_ASSERT_EQUAL( 700, m_fromxml.resNum() );
    CPPUNIT_ASSERT_EQUAL( 700, m_fromxml2.resNum() );
    CPPUNIT_ASSERT_EQUAL( 700, m_fromxml3.resNum() );
}

void ThreadTest::testName()
{
    CPPUNIT_ASSERT_EQUAL( QString( "Kita - 2ch client for KDE" ),
                          m_normal->name() );
    CPPUNIT_ASSERT_EQUAL( QString( "Kita - 2ch client for KDE" ),
                          m_noboard->name() );
    CPPUNIT_ASSERT_EQUAL( QString( "2ch browser thread" ),
                          m_fromxml.name() );
    CPPUNIT_ASSERT_EQUAL( QString( "2ch browser thread" ),
                          m_fromxml2.name() );
    CPPUNIT_ASSERT_EQUAL( QString( "2ch browser thread" ),
                          m_fromxml3.name() );
}

void ThreadTest::testBoardName()
{
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), m_normal->boardName() );
    // m_normalΥ󥹥ȥ饯ꤷƤΤ
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), m_noboard->boardName() );
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), m_fromxml.boardName() );
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), m_fromxml2.boardName() );
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), m_fromxml3.boardName() );
}

void ThreadTest::testBoardURL()
{
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/" ), m_normal->boardURL() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/" ), m_noboard->boardURL() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/" ), m_fromxml.boardURL() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/" ), m_fromxml2.boardURL() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/" ), m_fromxml3.boardURL() );
}

void ThreadTest::testBoardID()
{
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), m_normal->boardID() );
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), m_noboard->boardID() );
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), m_fromxml.boardID() );
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), m_fromxml2.boardID() );
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), m_fromxml3.boardID() );
}
