/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef BOARDTEST_H
#define BOARDTEST_H

#include <cppunit/extensions/HelperMacros.h>
#include <../board.h>

/**
@author Hideki Ikemoto
*/
class BoardTest : public CppUnit::TestFixture {
    CPPUNIT_TEST_SUITE( BoardTest );
    CPPUNIT_TEST( testID );
    CPPUNIT_TEST( testName );
    CPPUNIT_TEST( testSubjectTxtURL );
    CPPUNIT_TEST( testURL );
    CPPUNIT_TEST_SUITE_END();

    Kita::Board *m_normal, *m_share1, *m_share2, *m_share3, *m_null;
    Kita::Board m_fromxml, m_fromxml2; // FIXME: should use pointer.
public:
    void setUp();
    void tearDown();

    void testID();
    void testName();
    void testSubjectTxtURL();
    void testURL();
};

#endif
