/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "boardtest.h"

using namespace Kita;

void BoardTest::setUp()
{
    m_normal = new Board( "http://pc.2ch.net/linux/", "Linux" );

    Board::setName( "http://pc.2ch.net/linux/", "Linux" );
    m_share1 = Board::getByURL( "http://pc.2ch.net/linux/" );

    Board::setName( "http://pc.2ch.net/unix/", "U**x" );
    m_share2 = Board::getByURL( "http://pc.2ch.net/unix/" );

    Board::setName( "http://pc.2ch.net/unix/", "Unix" );
    m_share3 = Board::getByURL( "http://pc.2ch.net/unix/" );

    m_null = Board::getByURL( QString::null );

    m_fromxml = Board::fromXml( "<board>\n<url>http://pc.2ch.net/linux/</url>\n<name>Linux</name>\n</board>\n" );
    m_fromxml2 = Board::fromXml( "  <board>\n"
    "    <url>http://pc.2ch.net/linux/</url>\n"
    "    <name>Linux</name>\n"
    "  </board>\n"  );
}

void BoardTest::tearDown()
{
    delete m_normal;
}

void BoardTest::testID()
{
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), m_normal->id() );
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), m_share1->id() );
    CPPUNIT_ASSERT_EQUAL( QString( "unix" ), m_share2->id() );
    CPPUNIT_ASSERT_EQUAL( QString( "unix" ), m_share3->id() );
    CPPUNIT_ASSERT_EQUAL( QString::null, m_null->id() );
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), m_fromxml.id() );
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), m_fromxml2.id() );
}

void BoardTest::testName()
{
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), m_normal->name() );
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), m_share1->name() );
    CPPUNIT_ASSERT_EQUAL( QString( "U**x" ), m_share2->name() );
    CPPUNIT_ASSERT_EQUAL( QString( "Unix" ), m_share3->name() );
    CPPUNIT_ASSERT_EQUAL( QString::null, m_null->name() );
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), m_fromxml.name() );
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), m_fromxml2.name() );
}

void BoardTest::testSubjectTxtURL()
{
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/subject.txt" ),
                          m_normal->subjectTxtURL().url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/subject.txt" ),
                          m_share1->subjectTxtURL().url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/unix/subject.txt" ),
                          m_share2->subjectTxtURL().url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/unix/subject.txt" ),
                          m_share3->subjectTxtURL().url() );
    CPPUNIT_ASSERT_EQUAL( QString::null, m_null->subjectTxtURL().url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/subject.txt" ),
                          m_fromxml.subjectTxtURL().url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/subject.txt" ),
                          m_fromxml2.subjectTxtURL().url() );
}

void BoardTest::testURL()
{
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/"),
                          m_normal->url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/"),
                          m_share1->url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/unix/"),
                          m_share2->url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/unix/"),
                          m_share3->url() );
    CPPUNIT_ASSERT_EQUAL( QString::null, m_null->url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/"),
                          m_fromxml.url() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/"),
                          m_fromxml2.url() );
}
