/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "favoritethreads.h"

#include <kdebug.h>

FavoriteThreads* FavoriteThreads::instance = 0;

FavoriteThreads::FavoriteThreads()
{
}

FavoriteThreads::~FavoriteThreads()
{
}

FavoriteThreads* FavoriteThreads::getInstance()
{
  if( ! instance ) {
    instance = new FavoriteThreads();
  }
  return instance;
}

void FavoriteThreads::insert( const Kita::Thread* thread )
{
  if( ! m_threadDict.find( thread->datURL().url() ) ) {
    m_threadDict.insert( thread->datURL().url(), thread );
  }
}

void FavoriteThreads::remove( const QString& datURL )
{
  m_threadDict.remove( datURL );
}

bool FavoriteThreads::contains( const QString& datURL ) const
{
  if( m_threadDict.find( datURL ) ) {
    return true;
  } else {
    return false;
  }
}

FavoriteThreads* FavoriteThreads::fromXml( const QString& xml )
{
  FavoriteThreads* instance = FavoriteThreads::getInstance();

  FavoritesXmlParser parser;
  QXmlSimpleReader reader;
  QXmlInputSource source;
  source.setData( xml );
  reader.setContentHandler( &parser );
  reader.parse( &source );

  if( parser.isValid() ) {
    QPtrList<Kita::Thread> threads = parser.getThreads();

    instance->m_threadDict.clear();
    for( Kita::Thread* thread = threads.first(); thread; thread = threads.next() ) {
      instance->insert( thread );
    }
  } else {
    kdError() << "inValid" << endl;
  }

  return instance;
}

const QString FavoriteThreads::toXml() const
{
  QString ret;

  ret += "<favorites xmlns=\"http://kita.sourceforge.jp/ns/favorites\">\n";

//  FavoriteThreads::const_iterator it;
  QDictIterator<Kita::Thread> it( threads() );
  for( ; it.current(); ++it ) {
    ret += it.current()->toXmlFragment();
  }
  ret += "</favorites>\n";

  return ret;
}

bool FavoriteThreads::test()
{
  kdDebug() << "FavoriteThreads::test()" << endl;

  QString xml = "<favorites xmlns=\"http://kita.sourceforge.jp/ns/favorites\">\n"
                "<thread xmlns=\"http://kita.sourceforge.jp/ns/thread\">\n"
                "<daturl>http://pc.2ch.net/linux/dat/1022744633.dat</daturl>\n"
                "<name>2ch browser thread</name>\n"
                "<board xmlns=\"http://kita.sourceforge.jp/ns/board\">\n"
                "<url>http://pc.2ch.net/linux/</url>\n"
                "<name>Linux</name>\n"
                "</board>\n"
                "</thread>\n"
                "<thread xmlns=\"http://kita.sourceforge.jp/ns/thread\">\n"
                "<daturl>http://pc.2ch.net/unix/dat/956134538.dat</daturl>\n"
                "<name>NeXT</name>\n"
                "<board xmlns=\"http://kita.sourceforge.jp/ns/board\">\n"
                "<url>http://pc.2ch.net/unix/</url>\n"
                "<name>Unix</name>\n"
                "</board>\n"
                "</thread>\n"
                "</favorites>\n";

  FavoriteThreads* favorites = FavoriteThreads::fromXml( xml );
  QDict<Kita::Thread> threads = favorites->threads();

  if( threads.size() != 2 ) kdError() << "inValid: line=" << __LINE__ << endl;
  if( favorites->contains( "http://pc.2ch.net/linux/dat/1022744633.dat" ) != true ) {
    kdError() << "inValid: line=" << __LINE__;
  }
  if( favorites->contains( "http://pc.2ch.net/unix/dat/956134538.dat" ) != true ) {
    kdError() << "inValid: line=" << __LINE__;
  }
  return true;
}

bool FavoritesXmlParser::startElement( const QString& namespaceURI, const QString& localName, const QString& qName, const QXmlAttributes& atts )
{
  if( m_inThread ) {
    m_threadParser->startElement( namespaceURI, localName, qName, atts );
  } else if( m_inFavorites ) {
    if( localName == "thread" ) {
      m_inThread = true;
      m_threadParser = new Kita::ThreadXmlParser();
      m_threadParser->startElement( namespaceURI, localName, qName, atts );
    } else {
      // error
      return false;
    }
  } else {
    if( localName == "favorites" ) {
      m_inFavorites = true;
    } else {
      // error
      return false;
    }
  }
  return true;
}

bool FavoritesXmlParser::endElement( const QString& namespaceURI, const QString& localName, const QString& qName )
{
  if( localName == "thread" ) {
    m_inThread = false;
    m_threadParser->endElement( namespaceURI, localName, qName );
    Kita::Thread thread = m_threadParser->getThread();
    m_threadList.append( new Kita::Thread( thread.datURL(), thread.name(), thread.resNum() ) );

    delete m_threadParser;
    m_threadParser = 0;
  } else if( m_inThread ) {
    m_threadParser->endElement( namespaceURI, localName, qName );
  } else if( localName == "favorites" ) {
    m_inFavorites = false;
    m_isValid = true;
  } else {
    // error
    return false;
  }
  return true;
}

bool FavoritesXmlParser::characters( const QString& ch )
{
  if( m_inThread ) {
    m_threadParser->characters( ch );
  } else {
    m_characters = ch;
  }
  return true;
}

