/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KITABOARD_H
#define KITABOARD_H

#include <kurl.h>

#include <qptrlist.h>
#include <qxml.h>
#include <qdict.h>

#include "thread.h"

/**
@author Hideki Ikemoto
*/

namespace Kita {
  class Thread;

  class Board
  {
    QString m_boardURL;
    QString m_boardName;
    static QDict<Board>* m_boardDict;
  public:
    Board();
    Board(const QString& boardURL, const QString boardName = QString::null);
    ~Board();
    const KURL subjectTxtURL() const;
    const QString& url() const;
    const QString& name() const;
    const QString id() const;
    const QPtrList<Thread> getThreadList() const;

    const QString toXmlFragment() const;
    static Board fromXml( const QString& xml );

    // Factory method
    static Board* getByURL( const QString& boardURL );
    static void setName( const QString& boardURL, const QString& boardName );
  };

  class NullBoard : public Board
  {
  public:
    NullBoard();
    ~NullBoard();
  };

  class BoardXmlParser : public QXmlDefaultHandler
  {
    QString m_nameStr;
    QString m_urlStr;

    QString m_characters;
    Board m_board;
    bool m_inBoard;
    bool m_isValid;
  public:
    BoardXmlParser() : m_inBoard(false), m_isValid(false) {};
    ~BoardXmlParser() {};
    bool startElement( const QString& namespaceURI, const QString& localName, const QString& qName, const QXmlAttributes& atts );
    bool endElement( const QString& namespaceURI, const QString& localName, const QString& qName );
    bool characters( const QString& ch );
    bool isValid() const { return m_isValid; }
    Board getBoard() const { return m_board; }
  };
};

#endif
