/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KITATHREADVIEW_H_
#define _KITATHREADVIEW_H_

#include <qwidget.h>
#include <qcstring.h>

#include <kurl.h>
#include <dom/dom_node.h>
#include <kparts/browserextension.h>

#include "kitathreadviewbase.h"
#include "kita2ch.h"

class KURL;
class KitaHTMLPart;
class KitaWriteDialog;

#include <qvaluestack.h> // for gcc-2.9x
template<class T> class QValueStack;

namespace KIO {
  class Job;
};

#include <dom/html_base.h>

/**
 *
 * Hideki Ikemoto
 **/

class KitaThreadView : public KitaThreadViewBase
{
  Q_OBJECT

public:
  KitaThreadView(QWidget *parent, const char *name=0);
  ~KitaThreadView();
  QString threadSubject() const;
  QStringList parseSearchQuery(const QString &input);
  void searchNext(const QStringList &input);
  void highLighten(bool yes, const QStringList &input);

public slots:
  void slotReceiveThreadData(KIO::Job* job, const QByteArray& data);
  void slotRedirection(KIO::Job* job, const KURL &);
  void slotThreadResult(KIO::Job* job);
  void slotWriteButtonClicked();
  void slotCanceled(KIO::Job* job);
  void slotShowErrorDialog(const QString& input, const KURL& urlOfInput = 0);
  void slotDisplayContents(const QString& input, const KURL& urlOfInput = 0);
  void slotShowThread(const Kita2ch::Board& board, const Kita2ch::Thread& thread);
  void slotFontChanged(QFont& font);

protected:
  bool gotoAnchor(const QString& name);

protected slots:
  void slotDOMNodeActivated(const DOM::Node &node);
  bool gobackAnchor();
  void slotPopupMenu(KXMLGUIClient *, const QPoint&, const KURL&, const QString&, mode_t);
  void slotOpenURLRequest(const KURL&, const KParts::URLArgs&);

private: // Private attributes
  Kita2ch::Board m_board;
  Kita2ch::Thread m_thread;
  KitaHTMLPart* m_threadPart;
  QCString m_threadData;
  QCString m_writeResult;
  int m_serverTime;
  QWidget * m_parent;
  KIO::Job * m_currentJob;
  int m_labelMaxLength;
  Kita2ch::PostInfo m_postInfo;

  void insertSearchCombo();
  KURL filterReadCGI(const KURL&);
  int getServerTimeFromHttpHeaders(QString headers);
  void setSubjectLabel(const QString& boardName, const QString& threadName);
  KitaWriteDialog* openDialog(Kita2ch::PostInfo& info);

private slots:
  void slotSearchButton();
  void slotHighLightenButton(bool yes);
  void slotOnURL(const QString& url);
  void slotReloadButton();
  void slotPostStarted( KIO::Job*, const Kita2ch::PostInfo&);

signals:
  void showThreadCompleted(const KURL& threadUrl);
  void datURLRedirected(const KURL& newDatURL);
  void signalChangeStatusbar(const QString&);
  void postResponse( const QString& response, const KURL& bbscgi = KURL() );
  //re-impl signals of KParts::Browserextension of KHTMLPart
  void openURLRequest( const KURL &url, const KParts::URLArgs &args = KParts::URLArgs() );
  void createNewWindow( const KURL &url, const KParts::URLArgs &args = KParts::URLArgs() );
  void setLocationBarURL( const QString &url );
  void enableAction( const char * name, bool enabled );
  void popupMenu(KXMLGUIClient *, const QPoint&, const KURL&, const QString&, mode_t);
  void setVestedNum(const KURL& , int );
  void writeSucceeded();

  friend class KitaThreadPart;
};

#endif
