
#ifndef _KITA2CH_H_
#define _KITA2CH_H_

#include <qptrlist.h>

/**
 *
 * Hideki Ikemoto
 **/

#include <kurl.h>

#include <qdatetime.h>
#include <qptrlist.h>

namespace Kita2ch
{
  class Thread;
  
  class Board
  {
    KURL m_boardURL;
    QString m_boardName;
    QPtrList<Thread> m_threadList;
  public:
    Board();
    Board(const KURL& boardURL, const QString boardName = QString::null);
    ~Board();
    const KURL subjectTxtURL() const;
    const KURL url() const;
    const QString name() const;
    const QString id() const;
    QPtrList<Thread> getThreadList();
    void refreshChildList();
  };

  class Thread
  {
    KURL m_datURL;
    QString m_datID;
    QString m_boardID;
    QString m_threadName;
    int m_resNum;
  public:
    Thread();
    Thread(const KURL& datURL, const QString threadName = QString::null, int resNum = 0);
    ~Thread();
    const KURL datURL() const;
    const KURL url() const;
    const QString datID() const;
    int resNum() const;
    const QString name() const;
    void setName(QString name) { m_threadName = name; }
    void setResNum(int resNum) { m_resNum = resNum; }
  };

  class Comment
  {
    QString m_name;
    QString m_address;
    QDateTime m_dateTime;
    QString m_id;

    QString m_body;
    QString m_subject;
    bool m_isValid;
    QString m_dateId;
  public:
    Comment(QString line);
    ~Comment() {}
    QString getName() const { return m_name; }
    QString getAddress() const { return m_address; }
    QString getDateId() const;
    QString getBody() const { return m_body; }
    QString getSubject() const { return m_subject; }
    bool isValid() const { return m_isValid; }
    QString toHtml(int num) const;
  private:
    void parseDateId(QString&);
    QString linkedAddress() const;
    QString linkedBody() const;
  };

  enum K2chResultCode {
      K2ch_Unknown,
      K2ch_True,
      K2ch_False,
      K2ch_Error,
      K2ch_Check,
      K2ch_Cookie
  };
  
  class WriteResult
  {
    
    QString m_str;
  public:
    WriteResult(QString str);
    QString toString() const { return m_str; }
    K2chResultCode code() const;
    QString message() const;
    QString title() const;
  };

  struct PostInfo {
    PostInfo() {
	 bbscgi = "/test/bbs.cgi";
	 submit = "%91%53%90%d3%94%43%82%f0%95%89%82%a4%82%b1%82%c6%82%f0%8f%b3%91%f8%82%b5%82%c4%8f%91%82%ab%8d%9e%82%de";
    };
    QString host;
    QString bbscgi;
    QString name;
    QString mail;
    QString body;
    QString bbs;
    QString key;
    QString time;
    QString submit;
    QString cookie;
    bool check() const;
    QString postStr();
  };
};

#endif
