/*
 * Copyright (C) 2001 Hideki Ikemoto <ikemo@wakaba.jp>
 */

#ifndef _KITAVIEW_H_
#define _KITAVIEW_H_

#include <qwidget.h>
#include <kparts/part.h>
#include <kitaiface.h>

class QPainter;
class KURL;

/**
 * This is the main view class for Kita.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * This kita uses an HTML component as an example.
 *
 * @short Main view
 * @author Hideki Ikemoto <ikemo@wakaba.jp>
 * @version 0.1
 */
class KitaView : public QWidget, public KitaIface
{
    Q_OBJECT
public:
	/**
	 * Default constructor
	 */
    KitaView(QWidget *parent);

	/**
	 * Destructor
	 */
    virtual ~KitaView();

    /**
     * Random 'get' function
     */
    QString currentURL();

    /**
     * Random 'set' function accessed by DCOP
     */
    virtual void openURL(QString url);

    /**
     * Random 'set' function
     */
    virtual void openURL(const KURL& url);

    /**
     * Print this view to any medium -- paper or not
     */
    void print(QPainter *, int height, int width);

signals:
    /**
     * Use this signal to change the content of the statusbar
     */
    void signalChangeStatusbar(const QString& text);

    /**
     * Use this signal to change the content of the caption
     */
    void signalChangeCaption(const QString& text);

private slots:
    void slotOnURL(const QString& url);
    void slotSetTitle(const QString& title);

private:
    KParts::ReadOnlyPart *m_html;
};

#endif // _KITAVIEW_H_
