
#ifndef K2CHTREE_ITEM_H
#define K2CHTREE_ITEM_H

#include <qglobal.h>
#include <qvariant.h>
#include <qobject.h>
#include <kurl.h>
#include <kbookmarkdrag.h>
#include <kpopupmenu.h>

#include <konq_sidebartreeitem.h>
class QListViewItem;
class KonqSidebarTreeItem;

#include <kaction.h>
class KActionCollection;
class KAction;

template<class type> class QDict;

#include "k2ch.h"

class KonqSidebarK2chTreeItem;
class KonqSidebarK2chBaseItem;
class KonqSidebarK2chCategoryItem;
class KonqSidebarK2chBoardItem;
class KonqSidebarK2chThreadItem;

class KonqSidebarK2chTreeItem : public QObject, public KonqSidebarTreeItem
{
    Q_OBJECT
public:
    KonqSidebarK2chTreeItem( KonqSidebarTreeItem *parentItem, 
	    KonqSidebarTreeTopLevelItem *topLevelItem );
    virtual ~KonqSidebarK2chTreeItem() {};

    virtual KURL externalURL() const { return externalURL( m_method ); }; 
    virtual KURL externalURL( const K2ch::Method ) const { return 0; };

    virtual void setMethod ( const K2ch::Method new_method ) { m_method = new_method; }
    virtual K2ch::Method method() const { return m_method; }

    virtual QDragObject * dragObject( QWidget *, bool move = false );

    virtual void itemSelected();

    virtual void rightButtonPressed();

    enum Column {
	TITLE = 0
      , ASIS_Sort = 1
      , NAME_Sort = 2
    };
protected:
    virtual KBookmark makeKBookmark();

protected slots:
    virtual void refreshChildList() {};
    virtual void refreshCompleted( K2ch::Element *) {};
    virtual void processStat( KIO::Job * job );
    virtual void slotOpen();
    virtual void slotOpenNewWindow();
    virtual void slotCloseTree();

signals:
    void urlModified();

protected:
    KonqSidebarTreeItem * m_parentItem;
    KonqSidebarTreeTopLevelItem * m_topLevelItem;

    K2ch::Method m_method;

    KPopupMenu m_menu;
    KActionCollection m_collection;

    Q_UINT16 m_lastModified;
    KIO::Job * m_currentjob;
};


class KonqSidebarK2chBaseItem : public KonqSidebarK2chTreeItem
{
    Q_OBJECT
public:
    KonqSidebarK2chBaseItem( KonqSidebarTreeItem *parentItem, 
	    KonqSidebarTreeTopLevelItem *topLevelItem, 
	    const K2ch::Base &base );

    virtual ~KonqSidebarK2chBaseItem();

    K2ch::Base base() const { return *m_base; }
    void setBase( const K2ch::Base &_in ) { *m_base = _in; }

    virtual KURL externalURL( const K2ch::Method ) const;


protected slots:
    virtual void refreshChildList();
    virtual void refreshCompleted( K2ch::Element *);

protected:
    K2ch::Base * m_base;
};


class KonqSidebarK2chCategoryItem : public KonqSidebarK2chTreeItem
{
public:
    KonqSidebarK2chCategoryItem( KonqSidebarTreeItem *parentItem, 
	    KonqSidebarTreeTopLevelItem *topLevelItem, 
	    const K2ch::Category &category );

    virtual ~KonqSidebarK2chCategoryItem();

    K2ch::Category category() const { return *m_category; }
    void setCategory( const K2ch::Category &_in ) { *m_category = _in; }

    virtual void setOpen( bool );

protected:
    K2ch::Category * m_category;
};


class KonqSidebarK2chBoardItem : public KonqSidebarK2chTreeItem
{
    Q_OBJECT
public:
    KonqSidebarK2chBoardItem( KonqSidebarTreeItem *parentItem, 
	    KonqSidebarTreeTopLevelItem *topLevelItem, 
	    const K2ch::Board &board );

    virtual ~KonqSidebarK2chBoardItem();

    K2ch::Board board() const { return *m_board; }
    void setBoard( const K2ch::Board &_in ) { *m_board = _in; }

    virtual KURL externalURL( const K2ch::Method ) const;

    virtual void itemSelected();

protected slots:
    virtual void refreshChildList();
    virtual void refreshCompleted( K2ch::Element *);
    void checkUpdate();

protected:
    K2ch::Board * m_board;

private:
    QDict<KonqSidebarK2chThreadItem> * m_dict;
};


class KonqSidebarK2chThreadItem : public KonqSidebarK2chTreeItem
{
public:
    KonqSidebarK2chThreadItem( KonqSidebarTreeItem *parentItem, 
	    KonqSidebarTreeTopLevelItem *topLevelItem, 
	    const K2ch::Thread &thread );

    virtual ~KonqSidebarK2chThreadItem();

    K2ch::Thread thread() const { return *m_thread; }
    void setThread( const K2ch::Thread &_in );

    virtual KURL externalURL() const;
    virtual KURL externalURL( const K2ch::Method ) const;

    virtual void itemSelected();

    virtual void paintCell( QPainter *p, const QColorGroup & cg, int column, int width, int align );
protected:
    K2ch::Thread * m_thread;
    void initText();
};

#endif
// vim:sw=4
